$(function () {

    //-----------------------------------------------------
    //---------------- Toolbar Dropdown Row ----------------
    //-----------------------------------------------------

    // View row
    $(document).on('click', '.toolbar-row-view', function()
    {
        let modal = $('#modalUtilsAdmin');
        $(".modal-dialog").css({top: 0, left: 0});

        //let modalSize = '';
        let rowId = '';
        if($(this).closest('tr').length > 0)
        {
            rowId = $(this).closest('tr').attr('rowId');
        }
        else if($(this).closest('div.files-list').length > 0)
        {
            rowId = $(this).closest('div.files-list').attr('rowId');
        }

        if(!READ_PATH)
        {
            READ_PATH = 'bos/' + $('.main').attr('component') + '/read';
        }

        if(!VIEW_PATH)
        {
            VIEW_PATH = 'bos/' + $('.main').attr('component') + '/view';
        }

        let module_name = $('.main').attr('menu-name');
        modal.find('.modal-title').html('<i class="la la-eye"></i> เรียกดู<small class="text-muted"> | '+module_name.replace('_', ' ')+'</small>');
        modal.find('.modal-dialog').removeClass('modal-sm, modal-lg, modal-xl').addClass(modalSize);
        modal.find('.modal-body').html($('#loading').html());

        let html = '';
        let req = request_post(READ_PATH, {id: rowId});
        req.done(function(response, statusText, xhr)
        {
            if(response && !response.success)
            {
                error(response.message);
            }
            else{
                //console.log('Read เรียบร้อย..');

                let req;
                //check formsUI
                if (VIEW_PATH === false) {
                    console.log('Error view modal');
                } else {
                    req = request_view(VIEW_PATH, response.data);
                }

                req.done(function (data, statusText, xhr) {
                    //console.log('View เรียบร้อย..');
                    modal.modal('show');
                    html = data;
                });
            }
        });

        modal.on('shown.bs.modal', function()
        {
            //console.log('Shown modal....');
            modal.find('.modal-body').html(html);
        });
        modal.on('hidden.bs.modal', function()
        {
            //console.log('Hidden....');
            modal.find('.modal-body').html('');
            modal.modal('dispose');
        });
    });

    // Edit row
    var updateId;
    $(document).on('click', '.toolbar-row-edit', function()
    {
        let modal = $('#modalUtilsAdmin');
        $(".modal-dialog").css({top: 0, left: 0});
        //let modalSize = '';
        let rowId = '';
        if($(this).closest('tr').length > 0)
        {
            rowId = $(this).closest('tr').attr('rowId');
        }
        else if($(this).closest('div.files-list').length > 0)
        {
            rowId = $(this).closest('div.files-list').attr('rowId');
        }

        if(!READ_PATH)
        {
            READ_PATH = 'bos/' + $('.main').attr('component') + '/read';
        }

        if(!EDIT_PATH)
        {
            EDIT_PATH = 'bos/' + $('.main').attr('component') + '/edit';
        }

        let module_name = $('.main').attr('menu-name');
        modal.find('.modal-title').html('<i class="la la-pen"></i> แก้ไข<small class="text-muted"> | '+module_name.replace('_', ' ')+'</small>');
        modal.find('.modal-dialog').removeClass('modal-sm, modal-lg, modal-xl').addClass(modalSize);
        modal.find('.modal-body').html($('#loading').html());

        let html = '';
        let req = request_post(READ_PATH, {id: rowId});
        req.done(function(response, statusText, xhr)
        {
            if(response && !response.success)
            {
                error(response.message);
            }
            else{
                //console.log('Read เรียบร้อย..');
                //success('Read เรียบร้อย..');
                request_view(EDIT_PATH, response.data).done(function(data, statusText, xhr)
                {
                    //console.log('Edit เรียบร้อย..');
                    modal.modal('show');
                    html = data;
                    updateId = rowId;
                });
            }
        });

        modal.on('shown.bs.modal', function()
        {
            //console.log('Shown modal....');
            modal.find('.modal-body').html(html);

            modal.find('.btn-update').removeClass('d-none');
            form_validate_required();
            form_ckeditor(modal);
        });

        modal.on('hidden.bs.modal', function()
        {
            //console.log('Hidden....');
            modal.find('.modal-body').html('');
            modal.find('.btn-update').addClass('d-none');
            modal.modal('dispose');
        });
    });

    // Delete row
    $(document).on('click', '.toolbar-row-delete', function()
    {
        let btnDelete = $(this);

        let rowId = '';
        let rowTitle = '';
        if($(this).closest('tr').length > 0)
        {
            rowId = $(this).closest('tr').attr('rowId');
            rowTitle = $(this).closest('tr').find('.title').text();
        }
        else if($(this).closest('div.files-list').length > 0)
        {
            rowId = $(this).closest('div.files-list').attr('rowId');
            rowTitle = $(this).closest('div.files-list').find('.text-title').text();
        }

        if(!DELETE_PATH)
        {
            DELETE_PATH = 'bos/' + $('.main').attr('component') + '/delete';
        }

        if(!rowId)
        {
            warning('ไม่พบรายการใดๆ');
            return false;
        }
        else{
            $.confirm({
                title: 'ยันยันที่จะลบ',
                content: rowTitle,
                animateFromElement: false,
                buttons: {
                    confirm: {
                        text: 'ยืนยัน',
                        action: function () {
                            //$.alert('Confirmed!');
                            let dataId = [];
                            dataId.push(rowId);
                            let req = request_post(DELETE_PATH, {ids: dataId});
                            req.done(function(response, statusText, xhr)
                            {
                                if(response && !response.success)
                                {
                                    error(response.message);
                                }
                                else{
                                    //console.log('ลบเรียบร้อย..');
                                    success('ลบเรียบร้อย..');

                                    if(btnDelete.closest('tr').length > 0)
                                    {
                                        btnDelete.closest('tr').hide();
                                    }
                                    else if(btnDelete.closest('div.files-list').length > 0)
                                    {
                                        btnDelete.closest('div.files-list').hide();
                                    }
                                }
                            });
                        },
                        btnClass: 'btn-success',
                    },
                    cancel: {
                        text: 'ยกเลิก'
                    }
                }
            });
        }
    });

    // Enable/Disable row
    $(document).on('click', '.toolbar-row-enable, .toolbar-row-disable', function()
    {
        let className = this.className;
        let status = 1;
        let text = 'ใช้งาน';
        let label = textEnable;

        if(!STATUS_PATH)
        {
            STATUS_PATH = 'bos/' + $('.main').attr('component') + '/status';
        }

        if(STATUS_PATH.indexOf('contact') > -1){
            text = 'อ่านแล้ว';
            label = '<span class="badge badge-success toolbar-row-disable" title="คลิกเพื่อบอกว่ายังไม่อ่าน">อ่านแล้ว</span>';
        }

        if(className.indexOf('disable') > -1)
        {
            status = -1;
            text = 'ระงับ';
            label = textDisable;

            if(STATUS_PATH.indexOf('contact') > -1){
                text = 'ยังไม่อ่าน';
                label = '<span class="badge badge-secondary toolbar-row-enable font-italic" title="คลิกเพื่อบอกว่าอ่านแล้ว">ยังไม่อ่าน</span>';
            }
        }

        let rowId = $(this).closest('tr').attr('rowId');
        let textStatus = $(this).closest('tr').find('.text-status');
        let rowTitle = $(this).closest('tr').find('.title').text();

        if(!rowId)
        {
            warning('ไม่พบรายการใดๆ');
            return false;
        }
        else{
            $.confirm({
                title: 'ยืนยัน '+text,
                content: rowTitle,
                animateFromElement: false,
                buttons: {
                    confirm: {
                        text: 'ยืนยัน',
                        action: function () {
                            //$.alert('Confirmed!');
                            let dataId = [];
                            dataId.push(rowId);
                            let req = request_post(STATUS_PATH, {ids: dataId, status: status});
                            req.done(function(response, statusText, xhr)
                            {
                                if(response && !response.success)
                                {
                                    error(response.message);
                                }
                                else{
                                    //console.log(text + ' เรียบร้อย..');
                                    success(text + ' เรียบร้อย..');

                                    textStatus.html(row_status(status));
                                    textStatus.find('span').hide().fadeIn(1000);
                                }
                            });
                        },
                        btnClass: 'btn-success',
                    },
                    cancel: {
                        text: 'ยกเลิก'
                    }
                }
            });
        }
    });

    // Highlight/Un-Highlight row
    $(document).on('click', '.toolbar-row-highlight, .toolbar-row-unhighlight', function()
    {
        let className = this.className;
        let status = 1;
        let text = 'ทำไฮไลท์';
        let label = textMakeHighlight;

        if(!HIGHLIGHT_PATH)
        {
            HIGHLIGHT_PATH = 'bos/' + $('.main').attr('component') + '/highlight';
        }

        if(className.indexOf('unhighlight') > -1)
        {
            status = -1;
            text = 'ยกเลิกไฮไลท์';
            label = textUnHighlight;
        }

        let rowId = $(this).closest('tr').attr('rowId');
        let textHighlight = $(this).closest('tr').find('.text-highlight');
        let rowTitle = $(this).closest('tr').find('.title').text();

        if(!rowId)
        {
            warning('ไม่พบรายการใดๆ');
            return false;
        }
        else{
            $.confirm({
                title: 'ยืนยัน '+text,
                content: rowTitle,
                animateFromElement: false,
                buttons: {
                    confirm: {
                        text: 'ยืนยัน',
                        action: function () {
                            //$.alert('Confirmed!');
                            let dataId = [];
                            dataId.push(rowId);
                            let req = request_post(HIGHLIGHT_PATH, {ids: dataId, highlight: status});
                            req.done(function(response, statusText, xhr)
                            {
                                if(response && !response.success)
                                {
                                    error(response.message);
                                }
                                else{
                                    //console.log(text + ' เรียบร้อย..');
                                    success(text + ' เรียบร้อย..');

                                    textHighlight.html(label);
                                    textHighlight.find('span').hide().fadeIn(1000);
                                }
                            });
                        },
                        btnClass: 'btn-success',
                    },
                    cancel: {
                        text: 'ยกเลิก'
                    }
                }
            });
        }
    });

    // Add/View Item
    $(document).on('click', '.toolbar-row-item', function()
    {
        let modal = $('#modalUtilsAdmin');
        $(".modal-dialog").css({top: 0, left: 0});
        //let modalSize = '';
        let rowId = '';
        if($(this).closest('tr').length > 0)
        {
            rowId = $(this).closest('tr').attr('rowId');
        }
        else if($(this).closest('div.files-list').length > 0)
        {
            rowId = $(this).closest('div.files-list').attr('rowId');
        }

        if(!READ_PATH)
        {
            READ_PATH = 'bos/' + $('.main').attr('component') + '/read';
        }

        let module_name = $(this).closest('tr').find('.title').find('span').text();
        modal.find('.modal-title').html('<i class="la la-pen"></i> Item(s)<small class="text-muted"> | '+module_name.replace('_', ' ')+'</small>');
        modal.find('.modal-dialog').removeClass('modal-sm, modal-lg, modal-xl').addClass(modalSize);
        modal.find('.modal-body').html($('#loading').html());
        modal.find('.btn-update').addClass('btn-update-item').removeClass('btn-update');

        let html = '';
        let req = request_post(READ_PATH, {id: rowId});
        req.done(function(response, statusText, xhr)
        {
            if(response && !response.success)
            {
                error(response.message);
            }
            else{
                modal.modal('show');

                let data = '';
                if(response.data.option_item)
                {
                    data += '<ul class="list-group list-reorder">';
                    for(let row of response.data.option_item)
                    {
                        let keyId = row[row.keyId];
                        let cover_url = row.cover_url ? '<img src="'+row.cover_url+'" width="60"> ':'';
                        data += '<li class="list-group-item" rowId="' + keyId + '">' + cover_url + row.title + ' </li>';
                    }
                    data += '</ul>';
                }

                html = data;
                updateId = rowId;
            }
        });

        modal.on('shown.bs.modal', function()
        {
            //console.log('Shown modal....');
            let btnSave = modal.find('.btn-update-item');

            modal.find('.modal-body').html(html);
            modal.find('li').append('<span class="float-right"><button type="button" class="btn btn-light btn-sm shadow toolbar-item-moveup" title="คลิกเพื่อเลื่อนขึ้นไป"><i class="la la-arrow-up"></i></button> <button type="button" class="btn btn-light btn-sm shadow toolbar-item-movedown" title="คลิกเพื่อเลื่อนลงมา"><i class="la la-arrow-down"></i></button> <button type="button" class="btn btn-light btn-sm shadow toolbar-item-delete" title="นำรายการนี้ออก"><i class="la la-times"></i></button></span>');
            modal.find('.list-reorder').sortable({
                placeholder: 'ui-state-highlight'
            });
            modal.find('.list-reorder').disableSelection();

            reItems();

            function reItems()
            {
                modal.find('li').find('.toolbar-item-moveup, .toolbar-item-movedown').show();
                modal.find('li:first-child').find('.toolbar-item-moveup').hide();
                modal.find('li:last-child').find('.toolbar-item-movedown').hide();
            }

            modal.find('.toolbar-item-moveup').on('click', function()
            {
                $(this).closest('li').insertBefore($(this).closest('li').prev());
                reItems();
            });
            modal.find('.toolbar-item-movedown').on('click', function()
            {
                $(this).closest('li').insertAfter($(this).closest('li').next());
                reItems();
            });
            modal.find('.toolbar-item-delete').on('click', function()
            {
                if($(this).find('.la').hasClass('la-times'))
                {
                    $(this).find('.la').removeClass('la-times');
                    $(this).find('.la').addClass('la-trash');
                    $(this).closest('li').css({'background':'#ccc'});
                }
                else {
                    $(this).find('.la').removeClass('la-trash');
                    $(this).find('.la').addClass('la-times');
                    $(this).closest('li').css({'background':'inherit'});
                }
                reItems();
            });

            btnSave.off('click').on('click', function()
            {
                let btnSave = $(this);
                btnSave.prop('disabled', true);
                let dataId = [];
                let delIds = [];
                modal.find('.list-reorder li').each(function (i)
                {
                    let rowId = $(this).attr('rowId');
                    if(rowId)
                    {
                        if($(this).find('.la').hasClass('la-trash'))
                        {
                            delIds.push(rowId);
                        }
                        else {
                            dataId.push(rowId);
                        }
                    }
                });

                if(dataId)
                {
                    if(!REORDER_PATH)
                    {
                        REORDER_PATH = 'bos/' + $('.main').attr('component') + '_item/reorder_item';
                    }

                    let req = request_post(REORDER_PATH, {ids: dataId, del: delIds});
                    req.done(function (data, statusText, xhr)
                    {
                        //console.log('Re-order เรียบร้อย..');
                        success('Re-order เรียบร้อย..');
                        request_listing(filters);
                        btnSave.prop('disabled', false);
                        btnSave.addClass('d-none');
                        modal.modal('hide');
                    });
                }
            });

            $('.btn-add-parent-item').off('click').on('click', function()
            {
                console.log($('#parent_id').serialize());
            });

            modal.find('.btn-update-item').removeClass('d-none');
        });

        modal.on('hidden.bs.modal', function()
        {
            //console.log('Hidden....');
            modal.find('.modal-body').html('');
            modal.find('.btn-update-item').addClass('d-none btn-update').removeClass('btn-update-item');
            modal.modal('dispose');
        });
    });

    // Update items
    $(document).on('click', '.btn-update-item', function()
    {

    });

    //-----------------------------------------------------
    //---------------- Toolbar Dropdown Main ----------------
    //-----------------------------------------------------

    // Delete selected row
    $(document).on('click', '.toolbar-main-delete', function(){
        let dataId = [];
        let rowI = [];

        $('.checkbox-row').each(function(i)
        {
            let rowId = $(this).closest('tr').attr('rowId');
            if($(this).is(':checked'))
            {
                dataId.push(rowId);
                rowI.push(i);
            }
        });

        if(!DELETE_PATH)
        {
            DELETE_PATH = 'bos/' + $('.main').attr('component') + '/delete';
        }

        if(dataId.length > 0)
        {
            $.confirm({
                title: 'ยืนยันที่จะลบ',
                content: 'Total row : '+ dataId.length+'',
                animateFromElement: false,
                buttons: {
                    confirm: {
                        action: function () {
                            //$.alert('Confirmed!');
                            let req = request_post(DELETE_PATH, {ids: dataId});
                            req.done(function (response, statusText, xhr)
                            {
                                if(response && !response.success)
                                {
                                    error(response.message);
                                }
                                else{
                                    $('.checkbox-row').attr('checked', false);

                                    for (let i of rowI) {
                                        $('tr.row_no').eq(i).hide();
                                    }

                                    //console.log('ลบเรียบร้อย..');
                                    success('ลบเรียบร้อย..');
                                }
                                $('#checkAllRow').prop('checked', false);
                            });
                        },
                        btnClass: 'btn-success',
                    },
                    cancel: function () {
                        //$.alert('Canceled!');
                    }
                }
            });
        }
        else{
            warning('กรุณาเลือกอย่างน้อย 1 รายการ !');
            return false;
        }
    });

    //Enable/Disable selected row
    $(document).on('click', '.toolbar-main-enable, .toolbar-main-disable', function()
    {
        let className = this.className;
        let status = 1;
        let text = 'ใช้งาน';
        let label = textEnable;

        if(className.indexOf('disable') > -1)
        {
            status = -1;
            text = 'ระงับ';
            label = textDisable;
        }

        if(!STATUS_PATH)
        {
            STATUS_PATH = 'bos/' + $('.main').attr('component') + '/status';
        }

        let dataId = [];
        let rowI = [];
        $('.checkbox-row').each(function(i)
        {
            let rowId = $(this).closest('tr').attr('rowId');
            if($(this).is(':checked'))
            {
                dataId.push(rowId);
                rowI.push(i);
            }
        });

        if(dataId.length > 0)
        {
            $.confirm({
                title: 'ยันยันที่จะ '+text,
                content: 'Total row : '+ dataId.length+'',
                animateFromElement: false,
                buttons: {
                    confirm: {
                        action: function () {
                            //$.alert('Confirmed!');
                            let req = request_post(STATUS_PATH, {ids: dataId, status: status});
                            req.done(function (response, statusText, xhr)
                            {
                                if(response && !response.success)
                                {
                                    error(response.message);
                                }
                                else{
                                    $('.checkbox-row').prop('checked', false);

                                    for (let i of rowI) {
                                        $('tr.row_no').eq(i).find('.text-status').html(row_status(status));
                                        $('tr.row_no').eq(i).find('.text-status').find('span').hide().fadeIn(1000);
                                    }

                                    //console.log(text + ' เรียบร้อย..');
                                    success(text + ' เรียบร้อย..');
                                }

                                $('#checkAllRow').prop('checked', false);
                            });
                        },
                        btnClass: 'btn-success',
                    },
                    cancel: function () {
                        //$.alert('Canceled!');
                    }
                }
            });
        }
        else{
            warning('กรุณาเลือกอย่างน้อย 1 รายการ !');
            return false;
        }
    });

    //Highlight/Un-Highlight selected row
    $(document).on('click', '.toolbar-main-highlight, .toolbar-main-unhighlight', function()
    {
        let className = this.className;
        let status = 1;
        let text = 'ทำไฮไลท์';
        let label = textMakeHighlight;

        if(className.indexOf('unhighlight') > -1)
        {
            status = -1;
            text = 'ยกเลิกไฮไลท์';
            label = textUnHighlight;
        }

        if(!HIGHLIGHT_PATH)
        {
            HIGHLIGHT_PATH = 'bos/' + $('.main').attr('component') + '/highlight';
        }

        let dataId = [];
        let rowI = [];

        $('.checkbox-row').each(function(i)
        {
            let rowId = $(this).closest('tr').attr('rowId');
            if($(this).is(':checked'))
            {
                dataId.push(rowId);
                rowI.push(i);
            }
        });

        if(dataId.length > 0)
        {
            $.confirm({
                title: 'ยืนยันที่จะ '+text,
                content: 'Total row : '+ dataId.length+'',
                animateFromElement: false,
                buttons: {
                    confirm: {
                        action: function () {
                            //$.alert('Confirmed!');
                            let req = request_post(HIGHLIGHT_PATH, {ids: dataId, highlight: status});
                            req.done(function (response, statusText, xhr)
                            {
                                if(response && !response.success)
                                {
                                    error(response.message);
                                }
                                else{
                                    $('.checkbox-row').prop('checked', false);

                                    for (let i of rowI) {
                                        $('tr.row_no').eq(i).find('.text-highlight').html(label);
                                        $('tr.row_no').eq(i).find('.text-highlight').find('span').hide().fadeIn(1000);
                                    }

                                    //console.log(text + ' เรียบร้อย..');
                                    success(text + ' เรียบร้อย..');
                                }

                                $('#checkAllRow').prop('checked', false);
                            });
                        },
                        btnClass: 'btn-success',
                    },
                    cancel: function () {
                        //$.alert('Canceled!');
                    }
                }
            });
        }
        else{
            warning('กรุณาเลือกอย่างน้อย 1 รายการ !');
            return false;
        }
    });

    // Re-order highlight rows
    $(document).on('click', '.toolbar-main-reorder', function()
    {
        let modal = $('#modalUtilsAdmin');
        let modalSize = '';
        let btnSave = modal.find('.btn-save-order');
        $(".modal-dialog").css({top: 0, left: 0});

        modal.find('.modal-title').html('<i class="las la-sort-amount-up"></i> จัดลำดับไฮไลท์ <span class="small text-danger">ลากขึ้นลง เพื่อจัดลำดับ</span>');
        modal.find('.modal-dialog').removeClass('modal-sm, modal-lg, modal-xl').addClass(modalSize);
        //modal.find('.modal-body').html($('#loading').html());
        modal.modal('show');

        modal.on('shown.bs.modal', function()
        {
            //console.log('Shown modal....');
            //console.log('Listing highlight...');
            //request_listing(filters, false).done(function (response, statusText, xhr)
            {
                //console.log('ListingLoaded.');

                let html = '';
                //console.log('rowsTmp');
                //console.log(rowsTmp);
                if(rowsTmp && rowsTmp.length > 0)
                {
                    rowsTmp.sort(function (a, b)
                    {
                        return parseFloat(a.orderid) - parseFloat(b.orderid);
                    });

                    btnSave.removeClass('d-none');

                    html += '<ul class="list-group list-reorder">';
                    let isHl = 0;
                    for(let row of rowsTmp)
                    {
                        if(row.highlight === 1 || row.highlight === '1')
                        {
                            isHl = 1;
                            let title = '';
                            if(typeof row.name !== 'undefined')
                            {
                                title = row.name;
                            }
                            else if(typeof row.title !== 'undefined')
                            {
                                title = row.title;
                            }
                            else if(typeof row.title_th !== 'undefined')
                            {
                                title = row.title_th;
                            }
                            else if(typeof row.account_name !== 'undefined')
                            {
                                title = row.account_name+' - '+row.account_number+' - '+row.account_provider;
                            }

                            if(row.icon){
                                title = '<i class="'+row.icon+' mr-1"></i> ' + title;
                            }

                            html += '<li class="list-group-item" rowId="' + row[keyId] + '">' + title + ' </li>';
                        }
                    }
                    html += '</ul>';

                    if(isHl === 1)
                    {
                        modal.find('.modal-body').html(html);
                        modal.find('li').append('<span class="float-right"><button type="button" class="btn btn-light btn-sm  shadow toolbar-order-moveup" title="คลิกเพื่อเลื่อนขึ้นไป"><i class="la la-arrow-up"></i></button> <button type="button" class="btn btn-light btn-sm  shadow toolbar-order-movedown" title="คลิกเพื่อเลื่อนลงมา"><i class="la la-arrow-down"></i></button> </span>');

                        modal.find('.list-reorder').sortable({
                            placeholder: 'ui-state-highlight'
                        });
                        modal.find('.list-reorder').disableSelection();

                        reListing();

                        function reListing()
                        {
                            modal.find('li').find('.toolbar-order-moveup, .toolbar-order-movedown').show();
                            modal.find('li:first-child').find('.toolbar-order-moveup').hide();
                            modal.find('li:last-child').find('.toolbar-order-movedown').hide();
                        }

                        modal.find('.toolbar-order-moveup').on('click', function()
                        {
                            $(this).closest('li').insertBefore($(this).closest('li').prev());
                            reListing();
                        });
                        modal.find('.toolbar-order-movedown').on('click', function()
                        {
                            $(this).closest('li').insertAfter($(this).closest('li').next());
                            reListing();
                        });
                        modal.find('.toolbar-order-delete').on('click', function()
                        {
                            $(this).closest('li').remove();
                            reListing();
                        });

                        btnSave.off('click').on('click', function()
                        {
                            let btnSave = $(this);
                            btnSave.prop('disabled', true);
                            let dataId = [];
                            modal.find('.list-reorder li').each(function (i)
                            {
                                let rowId = $(this).attr('rowId');
                                if(rowId)
                                {
                                    dataId.push(rowId);
                                }
                            });

                            if(dataId)
                            {
                                if(!REORDER_PATH)
                                {
                                    REORDER_PATH = 'bos/' + $('.main').attr('component') + '/reorder';
                                }

                                let req = request_post(REORDER_PATH, {ids: dataId});
                                req.done(function (data, statusText, xhr)
                                {
                                    //console.log('Re-order เรียบร้อย..');
                                    success('จัดลำดับไฮไลท์ เรียบร้อย..');
                                    request_listing(filters);
                                    btnSave.prop('disabled', false);
                                    btnSave.addClass('d-none');
                                    modal.modal('hide');
                                });
                            }
                        });

                    }
                    else{
                        btnSave.addClass('d-none');
                        modal.find('.modal-body').html('<p class="text-center text-muted font-italic">ไม่พบ ไฮไลท์</p>');
                    }
                }
                else{
                    btnSave.addClass('d-none');
                    modal.find('.modal-body').html('<p class="text-center text-muted font-italic">ไม่พบ ไฮไลท์</p>');
                }
            }
            //);

        });
        modal.on('hidden.bs.modal', function()
        {
            //console.log('Hidden....');
            modal.find('.modal-body').html('');
            btnSave.addClass('d-none');
            modal.modal('dispose');
        });
    });

    //-----------------------------------------------------
    //---------------- Toolbar Main ----------------
    //-----------------------------------------------------

    // Add new row
    $(document).on('click', '.btn-addnew', function()
    {
        let modal = $('#modalUtilsAdmin');

        $(".modal-dialog").css({top: 0, left: 0});
        let module_name = $('.main').attr('menu-name');
        modal.find('.modal-title').html('<i class="la la-plus"></i> เพิ่มรายการใหม่<small class="text-muted"> | '+module_name.replace('_', ' ')+'</small>');
        modal.find('.btn-save').removeClass('d-none');
        modal.find('.btn-save-publish').removeClass('d-none');
        modal.find('.modal-dialog').removeClass('modal-sm, modal-lg, modal-xl').addClass(modalSize);


        if(!ADD_PATH)
        {
            ADD_PATH = 'bos/' + $('.main').attr('component') + '/add';
        }

        let html = '';
        request_view(ADD_PATH, null).done(function(data, statusText, xhr)
        {
            //console.log('Add เรียบร้อย..');
            modal.modal('show');
            html = data;
        });

        modal.on('shown.bs.modal', function ()
        {
            //console.log('Shown modal....');
            modal.find('.modal-body').html(html);
            modal.find('.btn-save').removeClass('d-none');

            form_validate_required();
            form_ckeditor(modal);
        });
        modal.on('hidden.bs.modal', function ()
        {
            //console.log('Hiden....');
            modal.find('.modal-body').html('');
            modal.find('.btn-save').addClass('d-none');
            modal.modal('dispose');
        });
    });
    // Add new row inline
    $(document).on('click', '.btn-addnew-inline', function()
    {
        let url = document.URL + '/add';
        window.location.href = url;
    });
    // Edit row inline
    $(document).on('click', '.toolbar-row-edit-inline', function()
    {
        let id = $(this).closest('.row_no').attr('rowId');
        let url = document.URL + '/edit/' + id;
        window.location.href = url;
    });
    // View row inline
    $(document).on('click', '.toolbar-row-view-inline', function()
    {
        let id = $(this).closest('.row_no').attr('rowId');
        let url = document.URL + '/view/' + id;
        window.location.href = url;
    });

    //Save new row
    $(document).on('click', '.btn-save', function()
    {
        if(form_validate())
        {
            let modal = $('#modalUtilsAdmin');
            let btn = $('.btn-save');
            let org_btn_text = btn.find('.text').text();
            btn.prop('disabled', true).prepend('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');
            btn.find('i').hide();
            btn.find('.text').text('กำลังบันทึก...');

            //update CKEditor
            if(typeof CKEDITOR !== 'undefined')
            {
                for(let i in CKEDITOR.instances)
                {
                    CKEDITOR.instances[i].updateElement();
                }
            }

            if(!CREATE_PATH)
            {
                CREATE_PATH = 'bos/' + $('.main').attr('component') + '/create';
            }

            let req = request_post(CREATE_PATH, $('#formData').serialize());
            req.done(function (response, statusText, xhr)
            {
                if(response && !response.success)
                {
                    error(response.message);
                    setTimeout(function () {
                        btn.prop('disabled', false);
                        btn.find('.spinner-border').remove();
                        btn.find('i').show();
                        btn.find('.text').text(org_btn_text);
                    }, 2000);
                }
                else{
                    //console.log('Save เรียบร้อย..');
                    success('บันทึกเรียบร้อย..');

                    btn.find('i').show();
                    btn.find('.spinner-border').remove();
                    btn.find('.text').text('บันทึกเรียบร้อย !');

                    setTimeout(function()
                    {
                        $('#modalUtilsAdmin').modal('hide');
                    }, 1000);

                    modal.on('hidden.bs.modal', function()
                    {
                        //console.log('Hidden....');
                        btn.find('.text').text('บันทึก');
                        btn.prop('disabled', false);
                        modal.modal('dispose');
                        request_listing(filters, false);
                    });
                }
            });
        }
    });

    // Update row
    $(document).on('click', '.btn-update', function()
    {
        if(form_validate())
        {
            let modal = $('#modalUtilsAdmin');
            let btn = $('.btn-update');
            let org_btn_text = btn.find('.text').text();
            btn.prop('disabled', true);
            btn.prepend('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');
            btn.find('i').hide();
            btn.find('.text').text('กำลังอัพเดต...');

            //update CKEditor
            if(typeof CKEDITOR !== 'undefined')
            {
                for(let i in CKEDITOR.instances)
                {
                    CKEDITOR.instances[i].updateElement();
                }
            }

            if(!UPDATE_PATH)
            {
                UPDATE_PATH = 'bos/' + $('.main').attr('component') + '/update';
            }

            let req = request_post(UPDATE_PATH, $('#formData').serialize());
            req.done(function (response, statusText, xhr)
            {
                setTimeout(function () {
                    btn.prop('disabled', false);
                    btn.find('.spinner-border').remove();
                    btn.find('i').show();
                    btn.find('.text').text(org_btn_text);
                }, 2000);
                if(response && !response.success)
                {
                    error(response.message);
                }
                else{
                    //console.log('อัพเดตเรียบร้อย..');
                    updateId = null;

                    success('อัพเดตเรียบร้อย..');
                    $('#delete_cover').prop('checked', false);

                    btn.find('i').show();
                    btn.find('.spinner-border').remove();
                    btn.find('.text').text('อัพเดตเรียบร้อย !');

                    setTimeout(function()
                    {
                        $('#modalUtilsAdmin').modal('hide');
                    }, 1000);

                    modal.on('hidden.bs.modal', function()
                    {
                        //console.log('Hidden....');
                        btn.find('.text').text('อัพเดต');
                        btn.prop('disabled', false);
                        modal.modal('dispose');
                        request_listing(filters, false);
                    });
                }
            });
        }
    });

    // Delete Gallery
    $(document).on('click', '.btn-delete-gallery', function () {
        let closest = $(this).closest('.form-group');
        if($(this).is(':checked'))
        {
            closest.find('.gallery-row-file').css({'opacity': '0.4'});
            closest.find('input[type=text]').prop('disabled', true);
        }
        else {
            closest.find('.gallery-row-file').css({'opacity': '1'});
            closest.find('input[type=text]').prop('disabled', false);
        }
    });

    // Download PDF
    $(document).on('click', '.btn-print-pdf', function()
    {
        let ths = $(this);
        let PDF_PATH = 'bos/' + $('.main').attr('component') + '/print_pdf';
        let dataId = [];

        //multiple row
        $('.checkbox-row').each(function(i)
        {
            let rowId = $(this).closest('tr').attr('rowId');
            if($(this).is(':checked'))
            {
                dataId.push(rowId);
            }
        });

        //single row
        if(dataId.length < 1)
        {
            let rowId = $(this).closest('tr').attr('rowId');
            dataId.push(rowId);
        }

        if(dataId.length < 1)
        {
            warning('กรุณาเลือกอย่างน้อย 1 รายการ');
        }
        else {
            let data = {};
            let filters = {
                ids: dataId,
                month: $('#filter_month').val(),
                year: $('#filter_year').val()
            };
            data.filters = filters;
            let req = request_get(PDF_PATH, data);
            req.done(function (response, statusText, xhr)
            {
                if(response && !response.success)
                {
                    error(response.message);
                }
                else{
                    //success('ลบเรียบร้อย..');

                    if(response.data.rows)
                    {
                        let PDF_PATH = BASE_URL + 'bos/' + $('.main').attr('component') + '/print_pdf';
                        let create_form = '<form id="form_pdf" method="post" action="'+PDF_PATH+'" class="d-none" target="_blank"><input type="hidden" id="data" name="data"><input type="hidden" id="filters" name="filters"></form>';
                        $('#form_pdf').remove();
                        $(create_form).insertAfter(ths);
                        $('#data').val(JSON.stringify(response.data.rows));
                        $('#filters').val(JSON.stringify(response.data.filters));
                        $('#form_pdf').submit();
                    }
                    else {
                        warning('ไม่พบข้อมูล.');
                    }
                }
            });
        }
    });

    // Save order id
    $(document).on('click', '.toolbar-save-order', function(){
        let REORDER_ROWS_PATH = 'bos/' + $('.main').attr('component') + '/reorder_rows';
        $.confirm({
            title: 'ยืนยันที่จะอัพเดตลำดับ',
            content: '',
            animateFromElement: false,
            buttons: {
                confirm: {
                    action: function () {
                        //$.alert('Confirmed!');
                        let req = request_post(REORDER_ROWS_PATH, $('#formListing').serialize());
                        req.done(function (response, statusText, xhr)
                        {
                            if(response && !response.success)
                            {
                                error(response.message);
                            }
                            else{
                                //console.log('ลบเรียบร้อย..');
                                success('อัพเดตลำดับเรียบร้อย..');
                                request_listing(filters);
                            }
                        });
                    },
                    btnClass: 'btn-primary',
                },
                cancel: function () {
                    //$.alert('Canceled!');
                }
            }
        });
    });

    $(document).on('change', '.form-reorder', function(){
        var FormAttr = $('#formListing').serializeArray();
        FormAttr.push({name: "current_id", value: $(this).data('id')});
        let REORDER_ROWS_PATH = 'bos/' + $('.main').attr('component') + '/reorder_change';
        $.confirm({
            title: 'ยืนยันที่จะอัพเดตลำดับ',
            content: '',
            animateFromElement: false,
            buttons: {
                confirm: {
                    action: function () {
                        //$.alert('Confirmed!');
                        let req = request_post(REORDER_ROWS_PATH, FormAttr);
                        req.done(function (response, statusText, xhr)
                        {
                            if(response && !response.success)
                            {
                                error(response.message);
                            }
                            else{
                                //console.log('ลบเรียบร้อย..');
                                success('อัพเดตลำดับเรียบร้อย..');
                                request_listing(filters);
                            }
                        });
                    },
                    btnClass: 'btn-primary',
                },
                cancel: function () {
                    //$.alert('Canceled!');
                }
            }
        });
    });

    $(document).on('click', '.toolbar-row-duplicate', function(){

        //let modalSize = '';
        let rowId = '';
        let rowTitle = '';
        if($(this).closest('tr').length > 0)
        {
            rowId = $(this).closest('tr').attr('rowId');
            rowTitle = $(this).closest('tr').find('.title').text();
        }
        else if($(this).closest('div.files-list').length > 0)
        {
            rowId = $(this).closest('div.files-list').attr('rowId');
            rowTitle = $(this).closest('div.files-list').find('.text-title').text();
        }

        let DUPLICATE_ROW_PATH = 'bos/' + $('.main').attr('component') + '/duplicate';
        $.confirm({
            title: 'ยืนยันที่จะคัดลอกรายการนี้',
            content: rowTitle,
            animateFromElement: false,
            buttons: {
                confirm: {
                    action: function () {
                        //$.alert('Confirmed!');
                        let req = request_post(DUPLICATE_ROW_PATH, {id: rowId});
                        req.done(function (response, statusText, xhr)
                        {
                            if(response && !response.success)
                            {
                                error(response.message);
                            }
                            else{
                                //console.log('ลบเรียบร้อย..');
                                success('คัดลอกเรียบร้อย..');
                                request_listing(filters);
                            }
                        });
                    },
                    btnClass: 'btn-primary',
                },
                cancel: function () {
                    //$.alert('Canceled!');
                }
            }
        });
    });

    // -------- Apply cover name to cover title, alt ------- //
    $(document).on('click', '#apply_name', function()
    {
        let checked = $(this).is(':checked');
        let cover_name = $('#cover').val();
        if(checked && cover_name)
        {
            cover_name = filename_form_path(cover_name);
        }
        else {
            cover_name = $('#title_th').val();
        }
        $('#cover_alt').val(cover_name);
        $('#cover_title').val(cover_name);
    });

});

// -------- Apply title to meta tag / cover title -------- //
function apply_title_to_meta(val)
{
    $('#meta_title').val(val);
    $('#meta_description').val(val);
    $('#meta_keywords').val(val.replace(/ /g, ','));
    if($('#tag_ids').length > 0)
    {
        $('#tag_ids').val(val.replace(/ /g, ','));
    }
}
function apply_title_to_cover(val)
{
    $('#cover_title').val(val);
    $('#cover_alt').val(val);
}
function filename_form_path(filename) {
    filename = filename.split(/[\\\/]/).pop();
    filename = filename.split('.').shift();
    filename = filename.replace(/,/g, ' ');
    filename = filename.replace(/_/g, ' ');
    filename = filename.replace(/-/g, ' ');
    return filename;
}