function request_http(method, url, data, forceData = false, mergeData = false)
{
    let passData = null;
    let processData = true;
    let defaultContentType = 'application/x-www-form-urlencoded; charset=UTF-8';
    let contentType = false;

    let fileUpload = $('#formData').find('input[type=file]');

    if(method === 'POST' && fileUpload.length > 0 && (fileUpload.eq(0).val() || fileUpload.eq(1).val() || fileUpload.eq(2).val()) || fileUpload.eq(3).val()){
        processData = false;
        passData = new FormData($('#formData')[0]);
    }
    else if(typeof data !== 'undefined')
    {
        passData = data;
        contentType = defaultContentType;
    }

    if(forceData)
    {
        processData = true;
        contentType = defaultContentType;
        passData = data;
    }

    if(mergeData)
    {
        passData = data + new FormData($('#formData')[0]);
    }

    let req = $.ajax({
        url: url,
        method: method,
        data: passData,
        headers: {'Authorization': 'Bearer ' + get_token()},
        contentType: contentType,
        cache: false,
        processData: processData,
        beforeSend: function(){
            //console.log('Loading......');

            let file = $('input[type=file]');
            if(file.length > 0)
            {
                //console.log('File checking......');
                $.each(file, function(i, field){
                    const file = field.files[0];
                    //console.log(file);
                    if(file)
                    {
                        let name = file.name.toLowerCase();
                        let size = file.size;
                        let type = file.type;
                        //console.log('name:' + name + ' size:' + size + ' type:' + type);
                    }
                });
            }
        }
    });

    req.fail(function(xhr, statusText){
        //console.log('Failed.. ' + xhr.status);
        //console.log(xhr);
        //console.log('statusCode:'+xhr.status);
        //console.log('statusText:'+statusText);

        let code = xhr.status;
        let msg = '';
        switch(xhr.status){
            case 404:
                msg = 'ไม่พบหน้านี้ (404)';
                //console.log(msg);
                break;
            case 401:
                msg = 'ไม่ได้รับสิทธิ์ (401)';
                break;
            case 500:
                msg = 'Internal Server Error (500)';
                break;
            default:
        }

        //console.log(code + ' : ' + msg);
        $.toast({text: code + ' : ' + msg, icon: 'error', position: 'top-right'});

    });

    req.done(function(data, statusText, xhr){
        //console.log('Done.. ' + xhr.status);
        //console.log(data);
        //console.log('statusText:'+statusText);
        //console.log('statusCode:'+xhr.status);
    });

    return req;
}

function request_post(url, data, forceData = false)
{
    return request_http('POST', OFFICE_API_URL + url, data, forceData);
}

function request_get(url, data, forceData = false)
{
    return request_http('GET', OFFICE_API_URL + url, data, forceData);
}

function request_view(url, data, forceData = false)
{
    return request_http('POST', BASE_URL + url, data, forceData);
}