$(function(){

    var attempts = 0;
    var btn_login = $('#btn-login');

    btn_login.on('click', function(e){
        var ths = $(this);

        if(!$('#email').val())
        {
            warning('กรุณาระบุอีเมล');
            $('#email').focus();
            return false;
        }
        else if(!validateEmail.test($('#email').val()))
        {
            warning('รูปแบบอีเมลไม่ถูต้อง');
            $('#email').focus();
            return false;
        }
        else if(!$('#password').val() || $('#password').val().length < 6 || $('#password').val().length > 20)
        {
            warning('กรอกรหัสผ่านอย่างน้อย 6 ตัวอักษร');
            $('#password').focus();
            return false;
        }
        else if(!$('#answer').val())
        {
            warning('กรุณาระบุคำคอบ');
            $('#answer').focus();
            return false;
        }
        else{

            showSpinner(ths, true);

            let data = {
                email: $('#email').val(),
                password: $('#password').val(),
                answer: $('#answer').val()
            };

            $.ajax({
                type: 'POST',
                url: OFFICE_API_URL + 'bos/login/auth',
                dataType: 'json',
                contentType: 'application/json; charset=utf-8',
                data: JSON.stringify(data),
                success: function(response){
                    hideSpinner(ths, true);
                    if(response.success)
                    {
                        attempts = 0;
                        success(response.message);
                        set_token(response.data.token);
                        window.location.href = BASE_URL + 'bos/home';
                    }
                    else{

                        attempts++;

                        if(parseInt(attempts) > 3)
                        {
                            attempts = 0;
                        }
                        error(response.message);
                    }
                }
            });

        }
    });

    $(document).on('keyup', '#password', function () {
        $('#showPassword').addClass('d-none');
        if($(this).val().length > 3)
        {
            $('#showPassword').removeClass('d-none');
        }
    });
    $(document).on('click', '#showPassword', function () {
        if($(this).prev('#password').length)
        {
            if($(this).prev('#password').attr('type') === 'password')
            {
                $('#password').attr('type', 'text');
                $(this).removeClass('la-eye').addClass('la-eye-slash');
            }
            else {
                $('#password').attr('type', 'password');
                $(this).removeClass('la-eye-slash').addClass('la-eye');
            }
        }
    });

});