let filters = {};

let LISTING_PATH = '';
let DELETE_PATH = '';
let STATUS_PATH = '';
let HIGHLIGHT_PATH = '';
let REORDER_PATH = '';
let READ_PATH = '';
let VIEW_PATH = '';
let EDIT_PATH = '';
let ADD_PATH = '';
let UPDATE_PATH = '';
let CREATE_PATH = '';
let EXISTING_PATH = '';
let parentItemId = '';
let parentItemCom = '';

$(document).ready(function() {

    // ------------------------------------------------------- //
    // SIDEBAR CONTROL
    // ------------------------------------------------------ //
    $('.navlink-toplevel, .navlink-second-level').on('click', function(){
        $(this).find('.fa.arrow').toggleClass('toggle-up', 'toggle-down');

        let classNameFirst = this.className;
        if(classNameFirst.indexOf('navlink-toplevel') > -1){
            let ths = $(this).closest('.nav-item');
            if(ths.hasClass('active')){
                ths.removeClass('active');
            }
            else {
                $('.sidebar-container .nav-item').removeClass('active');
                ths.addClass('active');
            }
        }
        if(classNameFirst.indexOf('navlink-second-level') > -1){
            let ths = $(this).closest('.nav-item');
            if(ths.hasClass('active')){
                ths.removeClass('active');
            }
            else {
                $('.nav-second-level .nav-item').removeClass('active');
                ths.addClass('active');
            }
        }
    });

    // ------------------------------------------------------- //
    // Multi Level dropdown
    // ------------------------------------------------------ //
    $("ul.dropdown-menu [data-toggle='dropdown']").on("click", function(event) {
        event.preventDefault();
        event.stopPropagation();

        $('.dropdown-menu .dropdown-menu.show').removeClass('show');
        $(this).siblings().toggleClass("show");


        if (!$(this).next().hasClass('show')) {
            $(this).parents('.dropdown-menu').first().find('.show').removeClass("show");
        }
        $(this).parents('li.nav-item.dropdown.show').on('hidden.bs.dropdown', function(e) {
            $('.dropdown-submenu .show').removeClass("show");
        });

    });

    // ------------------------------------------------------- //
    // TOGGLE SIDEBAR
    // ------------------------------------------------------ //
    hide_sidebar();
    $(document).on('click', '.sidebar-toggle', function(e){
        if($('.sidebar').hasClass('show'))
        {
            $('.nav .nav-item').removeClass('active');
            hide_sidebar();
            localStorage.setItem('SHOW_SIDEBAR', 'no');
        }
        else {
            show_sidebar();
            localStorage.setItem('SHOW_SIDEBAR', 'yes');
        }
    });
    function show_sidebar()
    {
        $('.sidebar').removeClass('hide').addClass('show');
        $('.sidebar').css('transition','all 0.5s');
        $('.main').removeClass('wide');
    }
    function hide_sidebar()
    {
        $('.sidebar').removeClass('show').addClass('hide');
        $('.main').addClass('wide');
    }
    if(localStorage.getItem('SHOW_SIDEBAR') === 'yes')
    {
        show_sidebar();
    }
    //End sidebar control

    //disable space input
    $(document).on('keypress', '#flag', function(e){
        if (e.which === 32) {
            return false;
        }
    });
    $('[data-toggle="tooltip"]').tooltip();

    // ------------------------------------------------------- //
    // POPUP GALLERY
    // ------------------------------------------------------ //
    $('.popup-gallery').magnificPopup({
        delegate: 'a.popup-item',
        type: 'image',
        tLoading: 'Loading image #%curr%...',
        mainClass: 'mfp-img-mobile',
        gallery: {
            enabled: true,
            navigateByImgClick: true,
            preload: [0, 1] // Will preload 0 - before current, and 1 after the current image
        },
        image: {
            tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
            titleSrc: function(item) {
                return item.el.attr('title');
            }
        }
    });

    $(document).magnificPopup({
        delegate: 'a.popup-image',
        type: 'image',
        closeOnContentClick: true,
        closeBtnInside: false,
        fixedContentPos: true,
        mainClass: 'mfp-no-margins mfp-with-zoom', // class to remove default margin from left and right side
        image: {
            verticalFit: true
        },
        zoom: {
            enabled: true,
            duration: 300 // don't foget to change the duration also in CSS
        }
    });

    $('.popup-youtube').magnificPopup({
        disableOn: 700,
        type: 'iframe',
        mainClass: 'mfp-fade',
        removalDelay: 160,
        preloader: false,

        fixedContentPos: false
    });

    // ------------------------------------------------------- //
    // TABLE ROW ACTIVE
    // ------------------------------------------------------ //
    $(document).on('click', '.card-table .table tr', function () {
       $('.card-table .table tr').removeClass('active');
       $(this).addClass('active');
    });

    // ------------------------------------------------------- //
    // CHOOSE COVER FILE
    // ------------------------------------------------------ //
    $(document).on('change', '#cover, #thumb, #seo_meta_image, #logo, #favicon, #billing_logo, #billing_seal, #billing_signature, #payment_cover, #splash_image, #popup_image, #special', function(e)
    {
        if(check_image_size(e.target.files[0].size))
        {
            let closest = $(this).closest('.choose-file-container');
            let preview = closest.next('.preview-image-holder');
            let fileName = e.target.files[0].name;

            let reader = new FileReader();
            reader.onload = function(e)
            {
                preview.find('img').attr('src', e.target.result);
            };
            reader.readAsDataURL(e.target.files[0]);

            if(closest.find('#file_name').length > 0)
            {
                closest.find('#file_name').val(fileName);
                if(closest.find('#file_name').val())
                {
                    $('.btn-clear-file').addClass('shadow').prop('disabled', false);
                }
                else{
                    $('.btn-clear-file').removeClass('shadow').prop('disabled', true);
                }
            }

            if(closest.find('.file_name').length > 0)
            {
                closest.find('.file_name').val(fileName);
                if(closest.find('.file_name').val())
                {
                    $('.btn-clear-file').addClass('shadow').prop('disabled', false);
                }
                else{
                    $('.btn-clear-file').removeClass('shadow').prop('disabled', true);
                }
            }
        }
    });

    $(document).on('click', '.btn-clear-file', function(e)
    {
        let closest = $(this).closest('.choose-file-container');
        let preview = closest.next('.preview-image-holder');
        let src = preview.find('.img-org').val();
        closest.find($('input[type=text]')).val('');
        closest.find($('input[type=file]')).val('');
        if(src) {
            closest.next('.preview-image-holder').find('img').attr('src', src);
        }else {
            closest.next('.preview-image-holder').find('img').attr('src', '');
        }
        $(this).removeClass('shadow').prop('disabled', true);
    });

    // ------------------------------------------------------- //
    // CHOOSE COVER FILE
    // ------------------------------------------------------ //
    $(document).on('change', ' #pdf,#technical_data,#spec_sheet', function(e)
    {
        if(check_pdf_size(e.target.files[0].size))
        {
            let closest = $(this).closest('.choose-file-container');
            let fileName = e.target.files[0].name;

            if(closest.find('.file_name').length > 0)
            {
                closest.find('.file_name').val(fileName);
                if(closest.find('.file_name').val())
                {
                    $('.btn-clear-file').addClass('shadow').prop('disabled', false);
                }
                else{
                    $('.btn-clear-file').removeClass('shadow').prop('disabled', true);
                }
            }
        }
    });

    // ------------------------------------------------------- //
    // WEB SETTING COLLAPSE
    // ------------------------------------------------------ //
    $(document).on('click', '.show-form-child', function(e)
    {
        if($(this).next('.collapse').length > 0)
        {
            $(this).addClass('active');
            $(this).next('.collapse').removeClass('collapse').addClass('collapsed');
        }
        else {
            $(this).removeClass('active');
            $(this).next('.collapsed').removeClass('collapsed').addClass('collapse');
        }
    });
});
//End document ready