<!DOCTYPE html>
<html lang="th">
<head>
   <meta charset="utf-8">
   <!--meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1" /-->
   <!--meta name="viewport" content="width=device-width, initial-scale=1.0"-->
   <meta name="viewport" content="width=device-width, initial-scale = 1.0,
maximum-scale=1.0, user-scalable=no" />
   <meta name="apple-mobile-web-app-capable" content="yes"/>

   <title>Product | Siam Anchor Fastener Industry</title>
   <meta name="description" content="<?php echo output_str($meta_description);?>">
   <meta name="keywords" content="<?php echo $meta_keywords;?>">
   <meta property="og:article:published_time" content="<?php echo $meta_published_time;?>" />
   <meta property="og:title" content="<?php echo output_str($meta_title);?>" />
   <meta property="og:site_name" content="<?php echo base_url();?>" />
   <meta property="og:description" content="<?php echo output_str($meta_description);?>" />
   <meta property="og:type" content="article" />
   <meta property="og:image" content="<?php echo $meta_image_url;?>" />
   <meta property="og:image:width" content="<?php echo $meta_image_width;?>" />
   <meta property="og:image:height" content="<?php echo $meta_image_height;?>" />
   <meta property="og:url" content="<?php echo $current_url;?>" />
   <link rel="image_src" href="<?php echo $meta_image_url;?>" />

   <?php include('application/views/front/th/inc/head.php');?>
</head>
<body> 
    <div class="preload">
        <span class="loader"></span>
    </div>
    <div class="page">
       <?php include('application/views/front/th/inc/header.php');?>
         
        <div class="section section-body"> 
            <div class="container">
                
                <div class="search-inputs flex-column ms-0">
                    <h5 class="blue mb-2 mt-2">Search by spec.</h5>

                   <form method="get" action="<?php echo base_url('search-spec');?>">
                      <input type="hidden" id="current_product_id" value="<?php echo $_GET['select_product_id']?>">
                      <input type="hidden" id="current_product_od" value="<?php echo $_GET['select_product_od']?>">
                      <input type="hidden" id="current_product_len" value="<?php echo $_GET['select_product_len']?>">
                      <div class="search-inputs">
                         <div class="col">
                            <select class="form-select" id="select_product_category_id" name="select_product_category_id">
                               <option value="">ประเภท</option>
                               <?php if(!empty($product_category_listing)) { foreach($product_category_listing as $rs) { ?>
                                  <option value="<?php echo output_text($rs->product_category_id);?>"<?php if($_GET['select_product_category_id'] == $rs->product_category_id){echo ' selected';}?>><?php echo output_text($rs->title);?></option>
                               <?php } } ?>
                            </select>
                         </div>

                         <div class="col">
                            <select class="form-select" name="select_product_id" id="select_product_id" disabled>
                               <option value="">ชื่อสินค้า</option>
                            </select>
                         </div>

                         <div class="col">
                            <select class="form-select" name="select_product_od" id="select_product_od" disabled>
                               <option value="">ขนาดเกลียว</option>
                            </select>
                         </div>

                         <div class="col">
                            <select class="form-select" name="select_product_len" id="select_product_len" disabled>
                               <option>ความยาว (mm.)</option>
                            </select>
                         </div>

                         <div class="button">
                            <button class="btn btn-search" type="submit">
                               <img class="svg-js" src="<?php echo base_url();?>theme/img/icons/icon-search.svg" alt="">
                               <span class="text">ค้นหา</span>
                            </button>
                         </div>
                      </div>
                   </form>
                    
                </div><!--search-inputs-->

                <div class="spec-result">
                   <?php $n=1; if(!empty($product_listing)) { foreach($product_listing as $rs) { ?>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="card-product wow fadeIn">
                                <a href="<?php echo product_url($rs);?>" class="card-link"></a>
                                <h3><?php echo output_text($rs->intro);?></h3>
                                <p><?php echo output_text($rs->title);?></p>
                                <div class="card-photo">
                                    <img src="<?php echo product_thumb_url($rs);?>" alt="<?php echo output_text($rs->title);?>">
                                </div>
                                
                            </div><!--card-product-->
                        </div><!--col-lg-6-->

                        <div class="col-lg-6">
                            <table class="table-spec">
                                <tr>
                                    <th>รหัสสินค้า</th>
                                    <th>ขนาดเกลียว</th>
                                    <th>ความยาว (mm.)</th>
                                </tr>
                               <?php if(!empty($rs->items)) { foreach($rs->items as $row) { ?>
                                <tr>
                                    <td><a href="<?php echo product_url($rs);?>?od=<?php echo output_text($row->od);?>&len=<?php echo output_text($row->length);?>#model"><?php echo output_text($row->code);?></a></td>
                                    <td><span><?php echo output_text($row->od);?></span></td>
                                    <td><span><?php echo output_text($row->length);?></span></td>
                                </tr>
                               <?php } } ?>
                            </table>
                        </div><!--col-lg-6-->
                    </div><!--row-->

                    <?php if($n != count($product_listing)){echo '<hr>';}?>
                   <?php $n++; } } else {echo '<p class="text-center mt-3">ไม่พบสินค้า</p>';} ?>
                </div><!--spec-result-->
            </div><!--container-->
        </div><!--section-->
       
       <?php include('application/views/front/th/inc/footer.php');?>
    </div><!--page-->
    
    <?php include('application/views/front/th/inc/body.php');?>
    
    <script> 
        // var $myModal = new bootstrap.Modal('#informModal');
        // $myModal.show(); 
    </script>
</body>
</html>
