<!DOCTYPE html>
<html lang="th">
<head>
   <meta charset="utf-8">
   <!--meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1" /-->
   <!--meta name="viewport" content="width=device-width, initial-scale=1.0"-->
   <meta name="viewport" content="width=device-width, initial-scale = 1.0,
maximum-scale=1.0, user-scalable=no" />
   <meta name="apple-mobile-web-app-capable" content="yes"/>

   <title>Product | Siam Anchor Fastener Industry</title>
   <meta name="description" content="<?php echo output_str($meta_description);?>">
   <meta name="keywords" content="<?php echo $meta_keywords;?>">
   <meta property="og:article:published_time" content="<?php echo $meta_published_time;?>" />
   <meta property="og:title" content="<?php echo output_str($meta_title);?>" />
   <meta property="og:site_name" content="<?php echo base_url();?>" />
   <meta property="og:description" content="<?php echo output_str($meta_description);?>" />
   <meta property="og:type" content="article" />
   <meta property="og:image" content="<?php echo $meta_image_url;?>" />
   <meta property="og:image:width" content="<?php echo $meta_image_width;?>" />
   <meta property="og:image:height" content="<?php echo $meta_image_height;?>" />
   <meta property="og:url" content="<?php echo $current_url;?>" />
   <link rel="image_src" href="<?php echo $meta_image_url;?>" />

   <?php include('application/views/front/th/inc/head.php');?>
</head>
<body>
    <div class="preload">
        <span class="loader"></span>
    </div>
    <div class="page">
       <?php include('application/views/front/th/inc/header.php');?>

        <nav class="navbar-breadcrumb">
            <div class="container">
                <ol class="breadcrumb">
                    <li><a href="<?php echo base_url('product');?>">Products</a></li>
                    <li><a href="<?php echo product_category_url($product_category_row);?>"><?php echo output_text($product_category_row->title);?></a></li>
                    <li><span><?php echo output_text($product_row->title);?></span></li>
                  </ol>
            </div>
        </nav>

       <div class="section section-body">
            <div class="container">
                <div class="product-details">
                    <div class="row">
                        <div class="col-xl-6 col-lg-5">
                            <div class="hgroup d-block d-lg-none">
                                <h1><span><span><?php echo output_text($product_row->intro);?></span></h1>
                                <h5><?php echo output_text($product_row->title);?></h5>
                            </div>


                            <div class="product-gallery">
                                <div class="swiper-desktop-group">
                                    <div class="swiper-container gallery-top desktop">
                                        <div class="swiper-wrapper">
                                           <?php if(!empty($product_gallery_listing)) { foreach($product_gallery_listing as $rs) { ?>
                                            <div class="swiper-slide">
                                                <a class="photo" href="<?php echo product_gallery_url($rs);?>" style="background-image: url(<?php echo product_gallery_url($rs);?>);" data-fancybox>
                                                    <img class="w-100" src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                                                </a>
                                            </div>
                                           <?php } } ?>
                                        </div>  <!--swiper-wrapper-->
                                    </div> <!--swiper-wrapper-->

                                    <div class="swiper-container gallery-thumbs desktop">
                                        <div class="swiper-wrapper">
                                           <?php if(!empty($product_gallery_listing)) { foreach($product_gallery_listing as $rs) { ?>
                                            <div class="swiper-slide">
                                                <div class="photo" style="background-image: url(<?php echo product_gallery_url($rs);?>);">
                                                    <img src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                                                </div>
                                            </div>
                                           <?php } } ?>
                                        </div><!--swiper-wrapper-->
                                    </div>
                                </div><!--swiper-desktop-group-->


                                <div class="swiper-mobile-group">
                                    <div class="swiper-container gallery-top mobile">
                                        <div class="swiper-wrapper">
                                           <?php if(!empty($product_gallery_listing)) { foreach($product_gallery_listing as $rs) { ?>
                                            <div class="swiper-slide">
                                                <a class="photo" href="<?php echo product_gallery_url($rs);?>" style="background-image: url(<?php echo product_gallery_url($rs);?>);" data-fancybox>
                                                    <img class="w-100" src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                                                </a>
                                            </div>
                                           <?php } } ?>
                                        </div>  <!--swiper-wrapper-->
                                    </div> <!--swiper-wrapper-->

                                    <div class="swiper-container gallery-thumbs mobile">
                                        <div class="swiper-wrapper">
                                           <?php if(!empty($product_gallery_listing)) { foreach($product_gallery_listing as $rs) { ?>
                                            <div class="swiper-slide">
                                                <div class="photo" style="background-image: url(<?php echo product_gallery_url($rs);?>);">
                                                    <img src="<?php echo base_url();?>theme/img/thumb/frame-100x100.png" alt="">
                                                </div>
                                            </div>
                                           <?php } } ?>
                                        </div><!--swiper-wrapper-->
                                    </div>
                                </div><!--swiper-mobile-group-->



                            </div><!--product-gallery-->
                        </div><!--col-xl-6-->

                        <div class="col-xl-6 col-lg-7">
                            <div class="product-infos">
                                <div class="hgroup d-none d-lg-block">
                                    <h1><span><span><?php echo output_text($product_row->intro);?></span></h1>
                                    <h5><?php echo output_text($product_row->title);?></h5>
                                </div>

                               <?php if(!empty($product_item_listing)) { ?>
                                <div class="spect-infos">
                                    <h5>กรุณาเลือกสินค้าเพื่อดูเสปค</h5>

                                    <select class="form-select spec" id="show-item-code">
                                       <option value="">-- เลือก --</option>
                                       <?php $od_arr = []; $n=0; foreach($product_item_listing as $rs) { $od_arr[] = $rs->od; ?>
                                        <option value="<?php echo output_text($rs->code);?>"<?php if($n==0 || (!empty($_GET['od']) && $_GET['od']==$rs->od)){echo ' selected';}?>><?php echo output_text($rs->code);?> (<?php echo output_text($rs->od);?>)</option>
                                       <?php $n++; } ?>
                                    </select>

                                   <div class="tab-content tab-spec">
                                      <div id="tab-st316">
                                         <table class="table table-spec">
                                            <tbody id="show-tab-item"></tbody>
                                         </table>
                                      </div><!--tab-pane-->
                                   </div>
                                </div><!--spect-infos-->
                               <?php } ?>

                                <div class="textgroup">
                                    <div class="section-icons">
                                        <span class="icons wow fadeInDown"></span>
                                        <span class="icons wow fadeInDown"></span>
                                        <span class="icons wow fadeInUp" data-wow-offset="0"></span>
                                        <span class="icons wow fadeInUp" data-wow-offset="0"></span>
                                    </div>
                                    <div class="inner">
                                       <?php echo output_text_detail($product_row->detail);?>
                                    </div>
                                </div>
                            </div><!--col-lg-6-->
                        </div><!--col-lg-6-->

                       <?php if(!empty($product_item_listing)) { ?>
                        <a name="model"></a>
                        <div class="col-12">
                            <div class="product-spec">
                                <div class="d-flex gap-3 mb-3">
                                    <div>
                                        <select class="form-select w-200 th" id="show-item-od">
                                            <option value="">ขนาดเกลียว</option>
                                           <?php foreach(array_unique($od_arr) as $od) { ?>
                                              <option value="<?php echo output_text($od);?>"<?php if($_GET['od'] == $od){echo ' selected';}?>><?php echo output_text($od);?></option>
                                           <?php } ?>
                                        </select>
                                    </div>
                                    <div>
                                        <select class="form-select w-200 th" id="show-item-length" disabled>
                                            <option value="">ความยาว (mm.)</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="table-responsive">
                                    <table class="table table-spec table-striped">
                                        <tr>
                                            <th>รหัสสินค้า</th>
                                            <th>ขนาดเกลียว</th>
                                            <th>ความยาว (mm.)</th>
                                            <th>ขนาดรูคอนกรีต (mm.)</th>
                                            <th>ความลึกรูคอนกรีต (mm.)</th>
                                            <th>แรงดึง (kN)</th>
                                            <th>แรงเฉือน (kN)</th>
                                        </tr>
                                       <tbody id="show-item">
                                       <?php foreach($product_item_listing as $rs) { ?>
                                        <tr>
                                            <td><?php echo output_text($rs->code);?></td>
                                            <td><?php echo output_text($rs->od);?></td>
                                            <td><?php echo output_text($rs->length);?></td>
                                            <td><?php echo output_text($rs->hole);?></td>
                                            <td><?php echo output_text($rs->depth);?></td>
                                            <td><?php echo output_text($rs->strength);?></td>
                                            <td><?php echo output_text($rs->shear);?></td>
                                        </tr>
                                       <?php } ?>
                                       </tbody>
                                    </table>
                                </div>

                            </div><!--product-spec-->
                        </div><!--col-12-->
                       <?php } ?>

                       <?php if(!empty($product_row->special_ext) || !empty($product_row->pdf_ext) || !empty($product_row->youtube_url)) { ?>
                        <div class="col-12">
                            <div class="product-installation">
                                <h5>Installation guide</h5>

                               <?php if(!empty($product_row->special_ext)) { ?>
                                <div class="row g-2">
                                    <div class="col-12">
                                        <a href="<?php echo product_special_url($product_row);?>" data-fancybox>
                                            <img class="w-100" src="<?php echo product_special_url($product_row);?>" alt="<?php echo output_text($product_row->title);?>">
                                        </a>
                                    </div>
                                </div><!--row-->
                               <?php } ?>

                               <?php if(!empty($product_row->youtube_url)) { ?>
                               <div class="row pt-xl-4 pt-4">
                                  <div class="col-12">
                                     <div class="ratio ratio-16x9">
                                        <iframe src="<?php echo $product_row->youtube_url;?>"></iframe>
                                     </div>
                                  </div>
                               </div>
                               <?php } ?>

                               <?php if(!empty($product_row->pdf_ext)) { ?>
                                <div class="d-flex pt-xl-5 pt-4">
                                    <a href="<?php echo product_pdf_url($product_row)?>" class="btn btn-outline btn-md download" target="_blank">
                                        <span class="icons">
                                            <img class="svg-js" src="<?php echo base_url();?>theme/img/icons/icon-download.svg" alt="">
                                        </span>
                                        Download full spec sheet
                                    </a>
                                </div>
                               <?php } ?>

                            </div><!--product-installation-->
                        </div><!--col-12-->
                       <?php } ?>

                       <?php if(!empty($product_item_listing)) { ?>
                        <div class="col-12">
                            <div class="product-quotation">
                                <h5 class="text-center">ขอใบเสนอราคา</h5>

                                <h6>เลือกสินค้า :</h6>
                                <ul class="nav product-code">
                                   <?php foreach($product_item_listing as $rs) { ?>
                                    <li><a data-bs-toggle="tab" href="#" data-product-id="<?php echo output_text($rs->product_id);?>" data-id="<?php echo output_text($rs->product_item_id);?>" class="item-select"><?php echo output_text($rs->code);?></a></li>
                                   <?php } ?>
                                </ul>

                                <div class="quantity">
                                    <h6>จำนวน (ตัว) :</h6>
                                    <input type="hidden" class="form-control th" id="product-id">
                                    <input type="hidden" class="form-control th" id="item-id">
                                    <input type="text" class="form-control th" id="cart-item" placeholder="ใส่จำนวน">
                                </div>

                                <div class="d-flex">
                                    <button class="btn btn-sm mx-auto" type="button" id="add-to-cart">+เพิ่มในใบขอราคา</button>
                                </div>
                            </div><!--product-quotation-->
                        </div>
                        <?php } ?>
                    </div><!--row-->


                </div><!--product-details-->
            </div><!--container-->
        </div><!--section-->

       <?php include('application/views/front/th/inc/footer.php');?>
    </div><!--page-->

    <div class="modal modal-alert fade" id="addProductModal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="icons main">
                        <img class="quotation" src="<?php echo base_url();?>theme/img/icons/icon-quotation.svg" alt="">
                    </div>
                    <h5 class="mb-2">
                        คุณได้เพิ่มสินค้า<br>
                        ในแบบใบขอราคาแล้ว
                    </h5>
                </div><!--modal-body-->

                <div class="modal-button pt-0">
                    <button class="btn btn-outline" type="button" data-bs-dismiss="modal">
                        เลือกสินค้าอื่น
                    </button>

                    <a class="btn btn-outline" href="<?php echo base_url('request-quotation');?>">
                        รีวิวใบขอราคา
                    </a>
                </div>
            </div><!--modal-content-->
        </div><!--modal-dialog-->
    </div><!-- Modal -->

    <?php include('application/views/front/th/inc/body.php');?>

    <script>
        // var $myModal = new bootstrap.Modal('#addProductModal');
        // $myModal.show();

        $('.tab-spec .tab-pane').hide();
        $('.tab-spec .tab-pane:first-child').show();
        $('select.spec').change(function () {
            dropdown = $('select.spec').val();
            $('.tab-spec .tab-pane').hide();
            $('#' + "tab-" + dropdown).show();
        });


        $(window).on("load", function(){
            var galleryThumbsDesktop = new Swiper('.gallery-thumbs.desktop', {
                spaceBetween:6,
                slidesPerView: 4,
                direction: 'vertical',
                loop: false,
                effect: 'slide',
                watchSlidesVisibility: true,
                observeParents: true,
                watchOverflow: true,
                /*simulateTouch:false,*/
            });

            var galleryDesktop = new Swiper('.gallery-top.desktop', {
                slidesPerView:1,
                spaceBetween:10,
                speed: 500,
                loop: false,
                observer: true,
                effect: 'slide',
                observeParents: true,
                watchOverflow: true,
                thumbs: {
                    swiper: galleryThumbsDesktop,
                }
            });

            var galleryThumbsMobile = new Swiper('.gallery-thumbs.mobile', {
                spaceBetween:8,
                slidesPerView: 4,
                loop: false,
                effect: 'slide',
                watchSlidesVisibility: true,
                observeParents: true,
                watchOverflow: true,
                /*simulateTouch:false,*/
            });

            var galleryMobile = new Swiper('.gallery-top.mobile', {
                slidesPerView:1,
                spaceBetween:10,
                speed: 500,
                loop: false,
                observer: true,
                effect: 'slide',
                observeParents: true,
                watchOverflow: true,
                thumbs: {
                    swiper: galleryThumbsMobile,
                }
            });
        });

        //get item
       function get_length_item(len = '') {
           let PATH = 'restful/front/product_item/get_length';
           let req = request_get(PATH, {product_id: <?php echo $product_row->product_id;?>, od: $('#show-item-od').val()});
           req.done(function (response, statusText, xhr)
           {
               if(response && !response.success)
               {
                   toast_error(response.message);
               }
               else{
                   let html = '<option value="">ความยาว (mm.)</option>';
                   if(response.data) {
                       for(let rs of response.data) {
                           html += '<option value="' + rs + '"';
                           if(len === rs){
                               html += ' selected';
                           }
                           html += '>' + rs + '</option>';
                       }
                   }
                   $('#show-item-length').html(html);
                   get_item();
               }
           });
       }
        function get_item() {
           let ths = $('#show-item');
            ths.html('');
            show_spinner(ths, true);
            let PATH = 'restful/front/product_item/get_item';
            let req = request_get(PATH, {product_id: <?php echo $product_row->product_id;?>, od: $('#show-item-od').val(), length: $('#show-item-length').val()});
            req.done(function (response, statusText, xhr)
            {
                hide_spinner(ths, true);
                if(response && !response.success)
                {
                    toast_error(response.message);
                }
                else{
                    let html = '';
                    if(response.data) {
                        for (let rs of response.data) {
                            html += '<tr><td>' + rs.code + '</td><td>' + rs.od + '</td><td>' + rs.length + '</td><td>' + rs.hole + '</td><td>' + rs.strength + '</td><td>' + rs.shear + '</td><td>' + rs.depth + '</td></tr>';
                        }
                    }
                    ths.html(html);
                }
            });
        }
       $('#show-item-od').on('change', function () {
           $('#show-item-length').prop('disabled', true);
           if($(this).val()) {
               $('#show-item-length').prop('disabled', false);
           }
           get_length_item();
       });
        $('#show-item-length').on('change', function () {
            get_item();
        });
        <?php if(!empty($_GET['od'])) { ?>
        $('#show-item-length').prop('disabled', false);
        get_length_item('<?php echo $_GET['len']?>');
        <?php } ?>

        function get_item_mobile() {
            let ths = $('#show-tab-item');
            ths.html('');
            show_spinner(ths, true);
            let PATH = 'restful/front/product_item/get_item_mobile';
            let req = request_get(PATH, {product_id: <?php echo $product_row->product_id;?>, code: $('#show-item-code').val()});
            req.done(function (response, statusText, xhr)
            {
                hide_spinner(ths, true);
                if(response && !response.success)
                {
                    toast_error(response.message);
                }
                else{
                    let html = '';
                    if(response.data) {
                        html += '<tr>\n' +
                            '                                                    <td>รหัสสินค้า</td>\n' +
                            '                                                    <td>' + response.data.code + '</td>\n' +
                            '                                                    <td></td>\n' +
                            '                                                </tr>\n' +
                            '                                                <tr>\n' +
                            '                                                    <td>ขนาดเกลียว</td>\n' +
                            '                                                    <td>' + response.data.od + '</td>\n' +
                            '                                                    <td></td>\n' +
                            '                                                </tr>\n' +
                            '                                                <tr>\n' +
                            '                                                    <td>ความยาว</td>\n' +
                            '                                                    <td>' + response.data.length + '</td>\n' +
                            '                                                    <td>mm.</td>\n' +
                            '                                                </tr>\n' +
                            '                                                <tr>\n' +
                            '                                                    <td>ขนาดรูคอนกรีต</td>\n' +
                            '                                                    <td>' + response.data.hole + '</td>\n' +
                            '                                                    <td>mm.</td>\n' +
                            '                                                </tr>\n' +
                            '                                                <tr>\n' +
                            '                                                    <td>แรงดึง</td>\n' +
                            '                                                    <td>' + response.data.strength + '</td>\n' +
                            '                                                    <td>kN.</td>\n' +
                            '                                                </tr>\n' +
                            '                                                <tr>\n' +
                            '                                                    <td>แรงเฉือน</td>\n' +
                            '                                                    <td>' + response.data.shear + '</td>\n' +
                            '                                                    <td>kN.</td>\n' +
                            '                                                </tr>\n' +
                            '                                                <tr>\n' +
                            '                                                    <td>ความลึกรูคอนกรีต</td>\n' +
                            '                                                    <td>' + response.data.depth + '</td>\n' +
                            '                                                    <td>mm</td>\n' +
                            '                                                </tr>';
                    }
                    ths.html(html);
                }
            });
        }
        get_item_mobile();
        $('#show-item-code').on('change', function () {
            get_item_mobile();
        });

    </script>
</body>
</html>
