<!-- Listing -->
<?php include 'application/views/bos/listing-tools.php';?>

<div class="card-body">
   <div class="table-responsive-sm table-listing popup-gallery">
      <table class="table table-striped table-hover table-bordered">
         <thead>
         <tr>
            <th class="w60">ID</th>
            <th>ชื่อเรื่อง</th>
            <th class="d-none d-sm-table-cell">กำหนดสิทธิ์</th>
            <th class="text-center d-none d-sm-table-cell w100">จำนวนผู้ใช้</th>
            <th class="text-center d-none d-sm-table-cell w80">สถานะ</th>
            <th class="text-center d-none d-sm-table-cell w130">อัพเดตเมื่อ</th>
            <th class="text-center w100">เครื่องมือ</th>
         </tr>
         <tr class="row-filter">
            <td></td>
            <td><input type="text" id="filter_title_th" placeholder="พิมพ์คำค้นหา" class="form-control"></td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="d-none d-sm-table-cell">
               <select class="form-control" id="filter_status">
                  <option value=""></option>
                  <option value="1">ใช้งาน</option>
                  <option value="-1">ระงับ</option>
               </select>
            </td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="inline-tools">
               <button class="btn btn-light btn-sm shadow toolbar-filter-search" type="button" title="ค้นหา"><i class="las la-search las la-pen align-middle"></i></button>
               <button class="btn btn-light btn-sm shadow toolbar-filter-reset" type="button" title="รีเซ็ต"><i class="las la-times las la-pen align-middle"></i></button>
            </td>
         </tr>
         </thead>
         <tbody id="load_rows">
         <!-- Display rows from js -->
         </tbody>
      </table>
   </div>
</div>

<?php include('application/views/bos/pager.php');?>

<!-- JS Services -->
<script type="text/javascript">
   //Path control
   let keyId = 'role_id';

   //Setup modal form
   var modalSize = 'modal-lg'; // modal-sm, none, modal-lg, modal-xl

   //Display row
   request_listing(null);

   function display_rows(data, start, limit)
   {
      let html = '';
      let row = data.rows;
      for(let i=start;i<(data.rows.length<limit ? data.rows.length:limit);i++){

          let perm_text = '';
          let permission = row[i].permissions;
          if(permission)
          {
              for(let p of permission)
              {
                  perm_text += '<p class="small mt-2">'+output_text(p.group)+'</p>';
                  if(p.menu)
                  {
                      for(let menu of p.menu)
                      {
                          perm_text += '<div class="small text-muted"><i class="la la-check-circle text-success"></i> '+output_text(menu)+'</div>';
                      }
                  }
              }
          }

         html += '<tr class="row_no" rowId="'+row[i].role_id+'">';
         html += '<th>'+row[i].role_id+'</th>';
         html += '<td><span class="title">'+output_text(row[i].title)+'</span></td>';
         html += '<td class="d-none d-sm-table-cell"><div style="width: 100%;max-height: 200px;overflow-y: auto;">'+perm_text+'</div></td>';
         html += '<td class="text-center d-none d-sm-table-cell">'+output_text(row[i].count_item)+'</td>';
         html += '<td class="text-center d-none d-sm-table-cell">'+row_status(row[i].status)+'</td>';
         html += '<td class="text-center d-none d-sm-table-cell small text-muted">'+row_updated(row[i])+'</td>';
         html += '<td class="inline-tools"><?php echo $button_inline;?></td>';
         html += '</tr>';
      }
      $("#load_rows").html(html);
   }

   //Toolbar : Filters
   $(document).on('click', '.toolbar-filter-search', function(){
      filters = {
          title: $('#filter_title').val(),
          status: $('#filter_status').val()
      };

       request_listing(filters);
   });
   $(document).on('click', '.toolbar-filter-reset', function(){
      $('#filter_title').val('');
      $('#filter_status').val('');

       request_listing({name: '', status: ''});
   });

   //Form validate
   let validate = {
       title: {
           input: 'text'
       }
   };

</script>