<!-- Listing -->
<?php include 'application/views/bos/listing-tools.php';?>

<div class="card-body">
   <div class="table-responsive-sm table-listing popup-gallery">
      <table class="table table-striped table-hover table-bordered">
         <thead>
         <tr>
            <th class="w60">ID</th>
            <th class="d-none d-sm-table-cell">Component</th>
            <th>Email</th>
            <th class="text-center d-none d-sm-table-cell w100">Action</th>
            <th class="text-center d-none d-sm-table-cell w80">สถานะ</th>
            <th class="text-center d-none d-sm-table-cell w100">IP</th>
            <th class="text-center d-none d-sm-table-cell w130">Created</th>
            <th class="text-center w100">เครื่องมือ</th>
         </tr>
         <tr class="row-filter">
            <td></td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="d-none d-sm-table-cell"><input type="text" id="filter_email" placeholder="พิมพ์คำค้นหา" class="form-control"></td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="d-none d-sm-table-cell"><input type="text" id="filter_ip" placeholder="Enter IP" class="form-control"></td>
            <td class="d-none d-sm-table-cell"></td>
            <td class="inline-tools">
               <button class="btn btn-light btn-sm shadow toolbar-filter-search" type="button" title="ค้นหา"><i class="las la-search las la-pen align-middle"></i></button>
               <button class="btn btn-light btn-sm shadow toolbar-filter-reset" type="button" title="รีเซ็ต"><i class="las la-times las la-pen align-middle"></i></button>
            </td>
         </tr>
         </thead>
         <tbody id="load_rows">
         <!-- Display rows from js -->
         </tbody>
      </table>
   </div>
</div>

<?php include('application/views/bos/pager.php');?>

<script type="text/javascript">
   let keyId = 'log_id';

   //Setup modal form
   var modalSize = ''; // modal-sm, none, modal-lg, modal-xl

   //Display row
   request_listing(null);

   function display_rows(data, start, limit)
   {
      let html = '';
      let row = data.rows;
      for(let i=start;i<(data.rows.length<limit ? data.rows.length:limit);i++){
         html += '<tr class="row_no" rowId="'+row[i].log_id+'">';
          html += '<th>'+row[i].log_id+'</th>';
         html += '<td class="d-none d-sm-table-cell">'+output_text(row[i].component)+'</td>';
         html += '<td><span class="title">'+output_text(row[i].email)+'</span></td>';
         html += '<td class="text-center d-none d-sm-table-cell"><span class="badge badge-light-primary">'+output_text(row[i].action)+'</span></td>';
         html += '<td class="text-center d-none d-sm-table-cell">'+row_success(row[i].status)+'</td>';
         html += '<td class="text-center d-none d-sm-table-cell">'+row[i].created_ip+'</td>';
         html += '<td class="text-center d-none d-sm-table-cell small text-muted">'+row_updated(row[i])+'</td>';
         html += '<td class="inline-tools"><?php echo $button_inline;?></td>';
         html += '</tr>';
      }
      $("#load_rows").html(html);
   }

   //Toolbar : Filters
   $(document).on('click', '.toolbar-filter-search', function(){
      filters = {
          email: $('#filter_email').val(),
          created_ip: $('#filter_ip').val()
      };

      request_listing(filters);
   });
   $(document).on('click', '.toolbar-filter-reset', function(){
      $('#filter_email').val('');
      $('#filter_ip').val('');

      request_listing({email: ''});
   });

</script>