<!-- Form Main -->
<div id="listing" class="form-main">

   <form id="formData" method="post">
      <div class="card-header">
         <div class="row">
            <div class="col-5">
               <div class="nav-breadcrumb">
                  <span class="nav-item"><i class="la la-user-edit"></i> ข้อมูลส่วนตัว</span>
                  <span class="nav-item">แก้ไข</span>
               </div>
            </div>
            <div class="col-7 toolbars text-right">
               <button type="button" class="btn btn-primary btn-sm btn-update-profile"><i class="la la-save align-middle"></i> อัพเดต</button>
            </div>
         </div>
      </div>
      <div class="card-body">

         <div class="form-legend show-form-child active">ทั่วไป</div>
         <div class="collapsed">
            <div class="form-row">
               <label for="firstname" class="col-sm-3 col-md-2 col-form-label">ชื่อจริง : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <input type="text" class="form-control" id="firstname" name="firstname" maxlength="100">
                     </div>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="lastname" class="col-sm-3 col-md-2 col-form-label">นามสกุล : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <input type="text" class="form-control" id="lastname" name="lastname" maxlength="100">
                     </div>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="nickname" class="col-sm-3 col-md-2 col-form-label">ชื่อเล่น : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <input type="text" class="form-control" id="nickname" name="nickname" maxlength="30">
                     </div>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="gender" class="col-sm-3 col-md-2 col-form-label">เพศ : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <div class="custom-control custom-radio custom-control-inline">
                           <input type="radio" id="male" name="gender" class="custom-control-input" value="1">
                           <label class="custom-control-label text-secondary" for="male">ชาย</label>
                        </div>
                        <div class="custom-control custom-radio custom-control-inline">
                           <input type="radio" id="female" name="gender" class="custom-control-input text-danger" value="2">
                           <label class="custom-control-label text-secondary" for="female">หญิง</label>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="phone" class="col-sm-3 col-md-2 col-form-label">เบอร์โทร : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <input type="text" class="form-control input-phone" id="phone" name="phone" maxlength="30">
                     </div>
                  </div>
               </div>
            </div>
         </div>

         <div class="form-legend show-form-child active">บัญชีผู้ใช้</div>
         <div class="collapsed">
            <div class="form-row">
               <label for="email" class="col-sm-3 col-md-2 col-form-label">อีเมล : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <input type="email" class="form-control" id="email" name="email" maxlength="150">
                        <input type="hidden" class="form-control" id="exclude" name="exclude">
                     </div>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="email" class="col-sm-3 col-md-2 col-form-label">รหัสผ่าน : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <div class="icon-inside">
                           <input type="password" class="form-control" id="password" name="password" value="" maxlength="20">
                           <i class="la la-eye text-secondary show-text"></i>
                        </div>
                        <small id="passwordHelpBlock" class="form-text text-muted">
                           6-20 ตัวอักษร ผสมระหว่าง English ตัวเล็ก+ตัวใหญ่+ตัวเลข เช่น 1Acbd2
                        </small>
                     </div>
                  </div>
               </div>
            </div>
            <div class="form-row">
               <label for="email" class="col-sm-3 col-md-2 col-form-label">ยืนยันรหัสผ่าน : </label>
               <div class="col-sm-9 col-md-10">
                  <div class="row">
                     <div class="col-sm-6">
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" value="" maxlength="20">
                     </div>
                  </div>
               </div>
            </div>
         </div>

         <div class="form-legend show-form-child active">รูปภาพประจำตัว</div>
         <div class="collapsed">
            <div class="form-row">
            <label for="coverx" class="col-sm-3 col-md-2 col-form-label">ภาพโปรไฟล์ : <p class="text-muted small"><?php echo show_cover_size(UPLOAD_ADMIN_AVATAR);?></p></label>
            <div class="col-sm-9 col-md-10">
               <div class="row">
                  <div class="col-sm-6">
                     <div class="choose-file-container">
                        <div class="input-group">
                           <input type="text" class="form-control file_name" disabled>
                           <div class="input-group-append">
                              <button type="button" class="btn btn-choose-file shadow input-group-text" onclick="$('#cover').trigger('click');" title="เลือกไฟล์ภาพที่ต้องการ">เลือกภาพ</button>
                           </div>
                           <div class="input-group-append">
                              <button type="button" class="btn btn-clear-file input-group-text" title="นำไฟล์ที่เลือกออก" disabled><i class="la la-times"></i></button>
                           </div>
                        </div>
                        <input type="file" class="form-control d-none" id="cover" name="cover" accept="<?php echo implode(',' , UPLOAD_ACCEPT_IMAGE_TYPE);?>">
                     </div>
                     <div class="preview-image-holder mt-2">
                        <img src="" width="<?php echo UPLOAD_ADMIN_AVATAR[0][1];?>" />
                     </div>
                     <div class="has-cover d-none mt-2">
                        <input type="checkbox" name="delete_cover" id="delete_cover">
                        <span class="text-muted small align-top">ลบภาพ</span>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         
      </div>

      </div>
   </form>

</div>

<script type="text/javascript">
    EXISTING_PATH = 'bos/profile/existing';
    $(document).ready(function () {
        form_read();

        // Update row
        $(document).on('click', '.btn-update-profile', function()
        {
            if(form_validate())
            {
                let btn = $('.btn-update-profile');
                btn.prop('disabled', true);
                btn.prepend('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');
                btn.find('i').hide();
                btn.find('.text').text('กำลังอัพเดต');

                if(!UPDATE_PATH)
                {
                    UPDATE_PATH = 'bos/profile/update';
                }

                let req = request_post(UPDATE_PATH, $('#formData').serialize());
                req.done(function (response, statusText, xhr)
                {
                    if(response && !response.success)
                    {
                        error(response.message);
                    }
                    else{
                        //console..log('อัพเดตเรียบร้อย..');
                        updateId = null;

                        success('อัพเดตเรียบร้อย..');

                        btn.find('i').show();
                        btn.find('.spinner-border').remove();
                        btn.find('.text').text('อัพเดตเรียบร้อย !');

                        form_read();
                    }
                });
            }
        });
    });

    function form_read() {
        let READ_PATH = 'bos/profile/read';
        let req = request_post(READ_PATH);
        req.done(function(response, statusText, xhr)
        {
            if(response && !response.success)
            {
                error(response.message);
            }
            else{
                //console.log(response);
                if(response.data)
                {
                    $('#firstname').val(response.data.firstname);
                    $('#lastname').val(response.data.lastname);
                    $('#nickname').val(response.data.nickname);
                    $('#phone').val(response.data.phone);
                    $('#email').val(response.data.email);
                    $('#exclude').val(response.data.email);
                    $('#delete_cover').val(response.data.cover_ext);

                    if(response.data.cover_url)
                    {
                        $('.preview-image-holder').find('img').attr('src', response.data.cover_url+'?x='+ Math.random());
                    }

                    if(response.data.gender === '1')
                    {
                        $('#male').prop('checked', true);
                    }
                    else if(response.data.gender === '2')
                    {
                        $('#female').prop('checked', true);
                    }

                    if(response.data.cover_ext)
                    {
                        $('.has-cover').removeClass('d-none');
                    }
                }
            }
        });
    }

    //Form validate
    let validate = {
        firstname: {
            input: 'text',
            msg: 'Please input first name'
        },
        lastname: {
            input: 'text',
            msg: 'Please input last name'
        },
        email: {
            input: 'email',
            msg: 'Please input valid email',
            email: true,
            existing: {
                require: true,
                exclude: '#exclude'
            }
        },
        password: {
            input: 'password',
            msg: 'Please input password<br />- contain at least one digit<br />- at least one lower case<br />- at least one upper case<br />- at least 6 from the mentioned characters',
            min: 6,
            max: 20,
            password: true
        },
        confirm_password: {
            input: 'password',
            msg: 'Please input confirm password',
            min: 6,
            max: 20,
            equalTo: {
                to: '#password',
                msg: 'Password do not match'
            }
        }
    };
</script>