<!-- Edit -->
<form id="formData" method="post">
   <div class="form-add">

      <ul class="nav nav-tabs justify-content-center modal-tab" role="tablist">
         <li class="nav-item">
            <a class="nav-link active" id="th-tab" data-toggle="tab" href="#th" role="tab" aria-controls="th" aria-selected="true" onclick="$('.modal-dialog').removeClass('modal-xl').addClass('modal-lg');">ข้อมูลสินค้า</a>
         </li>
         <li class="nav-item">
            <a class="nav-link" id="image-tab" data-toggle="tab" href="#image" role="tab" aria-controls="image" aria-selected="true" onclick="$('.modal-dialog').removeClass('modal-xl').addClass('modal-lg');">รูปภาพ & ไฟล์</a>
         </li>
         <li class="nav-item">
            <a class="nav-link" id="gallery-tab" data-toggle="tab" href="#gallery" role="tab" aria-controls="gallery" aria-selected="true" onclick="$('.modal-dialog').removeClass('modal-xl').addClass('modal-lg');">Gallery</a>
         </li>
         <li class="nav-item">
            <a class="nav-link" id="item-tab" data-toggle="tab" href="#item" role="tab" aria-controls="item" aria-selected="true" onclick="$('.modal-dialog').removeClass('modal-lg').addClass('modal-xl');">รุ่นสินค้า</a>
         </li>
      </ul>

      <div class="tab-content">
         <div class="tab-pane fade show active" id="th" role="tabpanel" aria-labelledby="th-tab">
            <div class="form-group row">
               <label for="product_category_id" class="col-sm-2 col-form-label">หมวดสินค้า : </label>
               <div class="col-sm-10">
                  <select class="form-control" name="product_category_id" id="product_category_id">
                     <option value="">-- Select --</option>
                  </select>
               </div>
            </div>
            <div class="form-group row">
               <label for="title" class="col-sm-2 col-form-label">ชื่อสินค้า (TH) : </label>
               <div class="col-sm-10">
                  <input type="text" class="form-control" id="title" name="title" maxlength="200">
               </div>
            </div>
            <div class="form-group row">
               <label for="title_en" class="col-sm-2 col-form-label">ชื่อสินค้า (EN) : </label>
               <div class="col-sm-10">
                  <input type="text" class="form-control" id="title_en" name="title_en" maxlength="200">
               </div>
            </div>
            <div class="form-group row">
               <label for="rewrite_url" class="col-sm-2 col-form-label">ลิ้งค์ : </label>
               <div class="col-sm-10">
                  <div class="input-group">
                     <div class="input-group-prepend">
                        <div class="input-group-text">product/{category}/</div>
                     </div>
                     <input type="text" class="form-control" id="rewrite_url" name="rewrite_url" maxlength="200" value="">
                  </div>
               </div>
            </div>
            <div class="form-group row">
               <label for="intro" class="col-sm-2 col-form-label">ชื่อย่อสินค้า (TH) : </label>
               <div class="col-sm-10">
                  <input type="text" class="form-control" id="intro" name="intro" maxlength="200">
               </div>
            </div>
            <div class="form-group row">
               <label for="intro_en" class="col-sm-2 col-form-label">ชื่อย่อสินค้า (EN) : </label>
               <div class="col-sm-10">
                  <input type="text" class="form-control" id="intro_en" name="intro_en" maxlength="200">
               </div>
            </div>
            <div class="form-group row">
               <label for="detail" class="col-sm-2 col-form-label">รายละเอียด (TH) : </label>
               <div class="col-sm-10">
                  <textarea class="form-control" id="detail" name="detail" rows="5"></textarea>
               </div>
            </div>
            <div class="form-group row">
               <label for="detail_en" class="col-sm-2 col-form-label">รายละเอียด (EN) : </label>
               <div class="col-sm-10">
                  <textarea class="form-control" id="detail_en" name="detail_en" rows="5"></textarea>
               </div>
            </div>
            <div class="form-group row">
               <label for="keyword" class="col-sm-2 col-form-label">คำค้นหา (TH) : </label>
               <div class="col-sm-10">
                  <textarea class="form-control" id="keyword" name="keyword" rows="2"></textarea>
               </div>
            </div>
            <div class="form-group row">
               <label for="keyword_en" class="col-sm-2 col-form-label">คำค้นหา (EN) : </label>
               <div class="col-sm-10">
                  <textarea class="form-control" id="keyword_en" name="keyword_en" rows="2"></textarea>
               </div>
            </div>
            <?php if($is_publish == 1){ ?>
               <div class="form-group row">
                  <label for="status" class="col-sm-2 col-form-label">สถานะ : </label>
                  <div class="col-sm-10">
                     <div class="custom-control custom-radio custom-control-inline">
                        <input type="radio" id="enabled" name="status" class="custom-control-input" value="1" checked>
                        <label class="custom-control-label text-success" for="enabled"><?php echo status_name(1);?></label>
                     </div>
                     <div class="custom-control custom-radio custom-control-inline">
                        <input type="radio" id="disabled" name="status" class="custom-control-input text-danger" value="0">
                        <label class="custom-control-label text-secondary font-italic" for="disabled"><?php echo status_name(0);?></label>
                     </div>
                  </div>
               </div>
            <?php } ?>
            <?php if($is_highlight == 1){ ?>
               <div class="form-group row">
                  <label for="orderid" class="col-sm-2 col-form-label">ลำดับ : </label>
                  <div class="col-sm-10">
                     <input type="hidden" id="highlight" name="highlight" value="1">
                     <input type="number" class="form-control" id="orderid" name="orderid" value="9999">
                  </div>
               </div>
            <?php } ?>
         </div>

         <div class="tab-pane fade" id="image" role="tabpanel" aria-labelledby="image-tab">
            <div class="form-group row">
               <label for="thumbx" class="col-sm-3 col-form-label">รูปภาพหลัก : <p class="text-muted small"><?php echo show_cover_size(UPLOAD_PRODUCT_THUMB);?><br />Max <?php echo UPLOAD_MAX_IMAGE_SIZE;?></p></label>
               <div class="col-sm-9">
                  <div class="choose-file-container">
                     <div class="input-group">
                        <input type="text" class="form-control file_name" disabled>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-choose-file shadow input-group-text" onclick="$('#thumb').trigger('click');" title="เลือกไฟล์ภาพที่ต้องการ">เลือกภาพ</button>
                        </div>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-clear-file input-group-text" title="นำไฟล์ที่เลือกออก" disabled><i class="la la-times"></i></button>
                        </div>
                     </div>
                     <input type="file" class="form-control" id="thumb" name="thumb" accept="<?php echo implode(',' , UPLOAD_ACCEPT_IMAGE_TYPE);?>">
                  </div>
                  <div class="preview-image-holder preview-image-holder-100p mt-2">
                     <img src="" />
                  </div>
               </div>
            </div>
            <div class="form-group row">
               <label for="specialx" class="col-sm-3 col-form-label">Installation Guide : <p class="text-muted small"><?php echo show_cover_size(UPLOAD_PRODUCT_SPECIAL);?><br />Max <?php echo UPLOAD_MAX_IMAGE_SIZE;?></p></label>
               <div class="col-sm-9">
                  <div class="choose-file-container">
                     <div class="input-group">
                        <input type="text" class="form-control file_name" disabled>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-choose-file shadow input-group-text" onclick="$('#special').trigger('click');" title="เลือกไฟล์ภาพที่ต้องการ">เลือกภาพ</button>
                        </div>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-clear-file input-group-text" title="นำไฟล์ที่เลือกออก" disabled><i class="la la-times"></i></button>
                        </div>
                     </div>
                     <input type="file" class="form-control" id="special" name="special" accept="<?php echo implode(',' , UPLOAD_ACCEPT_IMAGE_TYPE);?>">
                  </div>
                  <div class="preview-image-holder preview-image-holder-100p mt-2">
                     <img src="" />
                  </div>
               </div>
            </div>
            <div class="form-group row">
               <label for="youtube_url" class="col-sm-3 col-form-label">Youtube : </label>
               <div class="col-sm-9">
                  <textarea class="form-control" id="youtube_url" name="youtube_url" rows="2"></textarea>
                  <p class="small text-muted">ex. https://www.youtube.com/embed/xxxxxx</p>
               </div>
            </div>
            <div class="form-group row">
               <label for="pdfx" class="col-sm-3 col-form-label">Spec Sheet (PDF) :</label>
               <div class="col-sm-9">
                  <div class="choose-file-container">
                     <div class="input-group">
                        <input type="text" class="form-control file_name" disabled>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-choose-file shadow input-group-text" onclick="$('#pdf').trigger('click');" title="เลือกไฟล์ที่ต้องการ">เลือกไฟล์</button>
                        </div>
                        <div class="input-group-append">
                           <button type="button" class="btn btn-clear-file input-group-text" title="นำไฟล์ที่เลือกออก" disabled><i class="la la-times"></i></button>
                        </div>
                     </div>
                     <input type="file" class="form-control" id="pdf" name="pdf" accept="<?php echo implode(',' , UPLOAD_ACCEPT_PDF_TYPE);?>">
                  </div>
               </div>
            </div>
         </div>

         <div class="tab-pane fade" id="gallery" role="tabpanel" aria-labelledby="gallery-tab">
            <div class="gallery-container">
               <div class="form-group row">
                  <label for="image1" class="col-sm-12 col-form-label text-left">ภาพ : <span class="text-muted small"><?php echo show_cover_size(UPLOAD_PRODUCT_GALLERY);?></span> <button type="button" class="btn btn-sm btn-light delete-image-list d-none float-right" title="นำช่องเลือกไฟล์ภาพนี้ออก"><i class="la la-times"></i></button></label>
                  <div class="col-sm-12 pt-2 pb-2">
                     <div class="row gallery-row-file">
                        <div class="col-3">
                           <div class="preview-image-holder">
                              <img src="" />
                           </div>
                        </div>
                        <div class="col-9">
                           <div class="choose-file-container">
                              <div class="input-group">
                                 <div class="input-group-prepend">
                                    <div class="input-group-text">ลำดับ</div>
                                 </div>
                                 <input type="text" class="form-control input-no w60 file-order-no" name="gallery_orderid[]" maxlength="3">
                                 <input type="text" class="form-control input-gallery-name" name="gallery_name[]" disabled>
                                 <div class="input-group-append">
                                    <button type="button" class="btn btn-choose-file shadow input-group-text" onclick="$(this).closest('.choose-file-container').find('.input-gallery-file').trigger('click');" title="เลือกไฟล์ภาพที่ต้องการ">เลือกภาพ</button>
                                 </div>
                                 <div class="input-group-append">
                                    <button type="button" class="btn btn-clear-gallery input-group-text" disabled><i class="la la-times"></i></button>
                                 </div>
                              </div>
                              <input type="file" class="form-control input-gallery-file" name="gallery[]" accept="<?php echo implode(',' , UPLOAD_ACCEPT_IMAGE_TYPE);?>">
                           </div>
                           <div class="input-group mt-1">
                              <div class="input-group-prepend">
                                 <div class="input-group-text">ALT</div>
                              </div>
                              <input type="text" class="form-control input-gallery-alt" name="gallery_alt[]" maxlength="100">
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="form-group row">
               <div class="col-sm-12 p-2 text-right">
                  <span class="small text-danger">** ได้ครั้งละ <?php echo FILE_MAX_UPLOADS;?> ไฟล์</span>
                  <button type="button" class="btn btn-sm btn-success" id="add-new-image" title="คลิกเพื่อเพิ่มช่องเลือกไฟล์ภาพ"><i class="la la-plus align-middle"></i> เพิ่มภาพใหม่</button>
               </div>
            </div>
         </div>

         <div class="tab-pane fade" id="item" role="tabpanel" aria-labelledby="item-tab">
            <div class="col-sm-12 col-md-12">
               <table class="table table-bordered mt-2">
                  <thead>
                  <tr>
                     <th class="text-center">ลำดับ</th>
                     <th class="text-center">รหัสสินค้า</th>
                     <th class="text-center">ขนาดเกลียว</th>
                     <th class="text-center">ความยาว (mm)</th>
                     <th class="text-center">ขนาดรูคอนกรีต (mm)</th>
                     <th class="text-center">ความลึกรูคอนกรีต (mm.)</th>
                     <th class="text-center">แรงดึง (kN)</th>
                     <th class="text-center">แรงเฉือน (kN)</th>
                     <th class="text-center"></th>
                  </tr>
                  </thead>
                  <tbody id="item-listing">
                  <tr>
                     <td><input type="number" min="0" class="form-control text-center" name="orderids[]" maxlength="11"></td>
                     <td><input type="text" class="form-control" name="code[]" maxlength="10"</td>
                     <td><input type="text" class="form-control" name="od[]" maxlength="100" ></td>
                     <td><input type="text" class="form-control" name="length[]" maxlength="100"></td>
                     <td><input type="text" class="form-control" name="hole[]" maxlength="100"></td>
                     <td><input type="text" class="form-control" name="depth[]" maxlength="100"></td>
                     <td><input type="text" class="form-control" name="strength[]" maxlength="100"></td>
                     <td><input type="text" class="form-control" name="shear[]" maxlength="100"></td>
                     <td><button type="button" class="btn btn-sm btn-danger btn-remove-item" disabled><i class="la la-times align-middle"></i></button></td>
                  </tr>
                  </tbody>
               </table>
               <div class="mt-2 text-right">
                  <button type="button" class="btn btn-sm btn-success" id="add-new-item"><i class="la la-plus align-middle"></i> เพิ่มรุ่น</button>
               </div>
            </div>
         </div>
      </div>

   </div>
</form>

<script type="text/javascript">
    //Auto apply title to meta
    $('#title_en').on('keyup', function () {
        rewrite_url($(this).val());
    });
    $('#rewrite_url').on('keyup', function () {
        rewrite_url($(this).val());
    });

    selectList('bos/product_category/listing_order', '#product_category_id', 'product_category_id', null, null, 'title');
    $('#product_category_id').select2({theme: 'bootstrap4', width: 'style'});

    //region Add gallery images
    $('#add-new-image').on('click', function(){
        let gc = $('.gallery-container');
        let input_container = gc.find('.form-group').eq(0).html();
        gc.append('<div class="form-group row">'+input_container+'</div>');
        gc.find('.form-group').eq(parseInt(gc.find('.form-group.row').length)-1).find('img').attr('src', '');
        gc.find('.form-group.row').each(function (i) {
            if(i>0){
                gc.find('.form-group').eq(i).find('.file-order-no').val((100+i));
                gc.find('.form-group').eq(i).find('.btn-clear-gallery').prop('disabled', true);
                gc.find('.form-group').eq(i).find('.delete-image-list').removeClass('d-none').addClass('d-block');
                $('.delete-image-list').on('click', function(){
                    $(this).closest('.form-group').remove();
                });
            }
            if(parseInt($('.file-order-no').length) >= <?php echo FILE_MAX_UPLOADS;?>)
            {
                $('#add-new-image').prop('disabled', true);
            }
        });
    });
    $(document).on('change', '.input-gallery-file', function(e){
        let closest = $(this).closest('.form-group');
        if(check_image_size(e.target.files[0].size))
        {
            var preview = closest.find('.preview-image-holder');
            var fileName = e.target.files[0].name;

            closest.find('.input-gallery-name').val(fileName);
            fileName = filename_form_path(fileName);
            closest.find('.input-gallery-title, .input-gallery-alt').val(fileName);

            if(closest.find('.input-gallery-name').length)
            {
                if(closest.find('.input-gallery-name').val())
                {
                    $('.btn-clear-gallery').prop('disabled', false);
                }
                else{
                    $('.btn-clear-gallery').prop('disabled', true);
                }
            }

            let reader = new FileReader();
            reader.onload = function(e)
            {
                preview.find('img').attr('src', e.target.result);
            };
            reader.readAsDataURL(e.target.files[0]);
        }
    });
    $(document).on('click', '.btn-clear-gallery', function(e)
    {
        let closest = $(this).closest('.gallery-row-file');
        closest.find($('input[type=text]')).val('');
        closest.find($('input[type=file]')).val('');
        closest.find('.preview-image-holder').find('img').attr('src', '');
        $(this).prop('disabled', true);
    });
    $(document).on('click', '.delete-image-list', function(e)
    {
        if(parseInt($('.file-order-no').length) < <?php echo FILE_MAX_UPLOADS;?>)
        {
            $('#add-new-image').prop('disabled', false);
        }
    });
    //endregion

    //region add item
    $('#add-new-item').on('click', function(){
        let gc = $('#item-listing');
        let input = gc.find('tr:last').html();
        gc.append('<tr>'+input+'</tr>');
        $(input).find('input').val('');
        $('.btn-remove-item').prop('disabled', false);
        $('.btn-remove-item:last').prop('disabled', true);
        gc.find('tr').each(function (i) {
            $(this).find('input').eq(0).val(i+1);
        });
    });
    $(document).on('click', '.btn-remove-item', function(e)
    {
        $(this).closest('tr').remove();
        let gc = $('#item-listing');
        gc.find('tr').each(function (i) {
            $(this).find('input').eq(0).val(i+1);
        });
    });
    //endregion
</script>