<!-- Listing -->
<?php include 'application/views/bos/listing-tools.php';?>

<div class="card-body">
   <div class="table-responsive-sm table-listing popup-gallery">
      <form id="formListing">
         <table class="table table-striped table-hover table-bordered">
            <thead>
            <tr>
               <th class="text-center w80">ลำดับ</th>
               <th class="w60 text-center d-none d-sm-table-cell">Icon</th>
               <th>ชื่อหมวดหลัก</th>
               <th class="w130 d-none d-sm-table-cell">Flag</th>
               <th class="text-center d-none d-sm-table-cell w70">สถานะ</th>
               <th class="text-center d-none d-sm-table-cell w80">อัพเดตเมื่อ</th>
               <th class="text-center w100">เครื่องมือ</th>
            </tr>
            <tr class="row-filter">
               <?php if(!empty($this->is_highlight)){ ?>
                  <td class="inline-tools">
                     <button class="btn btn-light btn-sm shadow toolbar-save-order" type="button" title="บันทึก"><i class="las la-save align-middle"></i></button>
                  </td>
               <?php }else{ ?>
                  <td></td>
               <?php } ?>
               <td class="d-none d-sm-table-cell"></td>
               <td><input type="text" id="filter_name" placeholder="พิมพ์คำค้นหา" class="form-control"></td>
               <td class="d-none d-sm-table-cell"></td>
               <td class="d-none d-sm-table-cell"></td>
               <td class="w60 d-none d-sm-table-cell">
                  <select class="form-control" id="filter_status">
                     <option value=""></option>
                     <option value="1">ใช้งาน</option>
                     <option value="-1">ระงับ</option>
                  </select>
               </td>
               <td class="inline-tools">
                  <button class="btn btn-light btn-sm shadow toolbar-filter-search" type="button" title="ค้นหา"><i class="las la-search las la-pen align-middle"></i></button>
                  <button class="btn btn-light btn-sm shadow toolbar-filter-reset" type="button" title="รีเซ็ต"><i class="las la-times las la-pen align-middle"></i></button>
               </td>
            </tr>
            </thead>
            <tbody id="load_rows">
            <!-- Display rows from js -->
            </tbody>
         </table>
      </form>
   </div>
</div>

<?php include('application/views/bos/pager.php');?>

<script type="text/javascript">
    //Path control
    let keyId = 'menu_group_id';

    //Setup modal form
    var modalSize = ''; // modal-sm, none, modal-lg, modal-xl

    //Display row
    request_listing(null);

    function display_rows(data, start, limit)
    {
        let html = '';
        let row = data.rows;
        for(let i=start;i<(data.rows.length<limit ? data.rows.length:limit);i++){
            html += '<tr class="row_no" rowId="'+row[i].menu_group_id+'">';
            html += '<th><input type="text" class="form-control form-control-sm text-center" name="orderids['+row[i].menu_group_id+']" value="'+output_text(row[i].orderid)+'"></th>';
            html += '<td class="text-center d-none d-sm-table-cell"><i class="'+output_text(row[i].icon)+'"></i></td>';
            html += '<td><span class="title">'+output_text(row[i].name)+'</span></td>';
            html += '<td class="d-none d-sm-table-cell">'+output_text(row[i].flag)+'</td>';
            html += '<td class="text-center d-none d-sm-table-cell">'+row_status(row[i].status)+'</td>';
            html += '<td class="text-center d-none d-sm-table-cell small text-muted">'+row_updated(row[i])+'</td>';
            html += '<td class="inline-tools"><?php echo $button_inline;?></td>';
            html += '</tr>';
        }
        $("#load_rows").html(html);
    }

    //Toolbar : Filters
    $(document).on('click', '.toolbar-filter-search', function(){
        filters = {
            name: $('#filter_name').val(),
            status: $('#filter_status').val()
        };

        request_listing(filters);
    });
    $(document).on('click', '.toolbar-filter-reset', function(){
        $('#filter_name').val('');
        $('#filter_status').val('');

        request_listing({name: '', status: ''});
    });

    //Form validate
    let validate = {
        title: {
            input: 'text'
        },
        icon: {
            input: 'text'
        },
        flag: {
            input: 'text',
            eng: true,
            existing: {
                require: true,
                exclude: '#exclude'
            }
        }
    };

</script>