<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Menu_model extends MY_Model
{
   public function __construct()
   {
      parent::__construct();

      $this->table_name = 'cms_menu';
      $this->primary_key = 'menu_id';
      $this->set_ref = TRUE;
   }

   /**
    *
    * For menu permission
    *
    * @return mixed
    */
   public function listing($filters = NULL, $per_page = NULL, $offset = NULL)
   {
      $this->db->distinct();
      $this->db->where('n.status', GLOBAL_STATUS_ENABLED);
      $this->db->order_by('n.orderid', 'ASC');
      $this->db->order_by('n.menu_id', 'DESC');
      $result = $this->db->get($this->table_name. ' n')->result();

      return $result;
   }

   public function listing_by_label($filters = NULL)
   {
      $this->db->distinct();
      $this->db->select('n.*, c.title as remark');
      $this->db->where('n.status', GLOBAL_STATUS_ENABLED);
      $this->db->order_by('n.label', 'ASC');
      $this->db->join('cms_menu_group c', 'c.menu_group_id=n.menu_group_id', 'LEFT');
      $result = $this->db->get($this->table_name.' n')->result();

      return $result;
   }

   /**
    *
    * For menu permission
    *
    * @return mixed
    */
   public function list_for_role()
   {
      $this->db->distinct();
      $this->db->select('p.menu_id, p.title, p.flag, p.parent_id, p.label, p.menu_group_id, p.action_listing, p.action_view, p.action_add, p.action_edit, p.action_delete, p.action_publish, p.action_highlight');
      $this->db->where('status', GLOBAL_STATUS_ENABLED);
      $this->db->order_by('p.orderid', 'ASC');
      $this->db->order_by('p.menu_id', 'DESC');
      $result = $this->db->get($this->table_name.' p')->result();

      return $result;
   }

   public function lists($filters = NULL)
   {
      $this->db->select('n.menu_id, n.title as name, n.flag, n.highlight, n.status, n.orderid, n.updated_at, n.updated_by, u.firstname as admin, g.title as menu_group, t.title as parent, n.parent_id, n.label, n.action_listing, n.action_view, n.action_add, n.action_edit, n.action_delete, n.action_publish, n.action_highlight');
      $this->db->order_by('g.highlight', 'DESC');
      $this->db->order_by('g.orderid', 'ASC');
      $this->db->order_by('n.orderid', 'ASC');
      $this->db->order_by('n.menu_id', 'DESC');
      $this->db->order_by('n.title', 'ASC');

      //if($limit > 0)
      //{
      //   $this->db->limit($limit, 0);
      //}

      if(!empty($filters))
      {
         if(!empty($filters['name']))
         {
            $this->db->like('n.title', input_to_sql($filters['name']));
         }
         if(!empty($filters['menu_group_id']))
         {
            $this->db->where('n.menu_group_id', input_to_sql($filters['menu_group_id']));
         }
         if(!empty($filters['status']))
         {
            $this->db->where('n.status', $filters['status'] == 1 ? 1:0);
         }
      }

      $this->db->join('cms_menu_group g', 'g.menu_group_id=n.menu_group_id', 'LEFT');
      $this->db->join('cms_menu t', 't.menu_id=n.parent_id', 'LEFT');
      $this->db->join('cms_users u', 'u.user_id=n.created_by', 'LEFT');
      $result = $this->db->get($this->table_name.' n')->result();
      return $result;
   }

   public function lists_order($filters = NULL)
   {

      $this->db->select('n.menu_id, n.title as name, n.flag, n.highlight, n.status, n.orderid, n.updated_at, n.updated_by, u.firstname as admin, g.title as menu_group, t.title as parent, , t.label as parent_label, n.parent_id, n.label, n.action_listing, n.action_view, n.action_add, n.action_edit, n.action_delete, n.action_publish, n.action_highlight');
      $this->db->order_by('n.orderid', 'ASC');
      $this->db->order_by('n.menu_id', 'DESC');
      $this->db->order_by('n.title', 'ASC');

      //if($limit > 0)
      //{
      //   $this->db->limit($limit, 0);
      //}

      if(!empty($filters))
      {
         if(!empty($filters['name']))
         {
            $this->db->like('n.title', input_to_sql($filters['name']));
         }
         if(!empty($filters['menu_group_id']))
         {
            $this->db->where('n.menu_group_id', input_to_sql($filters['menu_group_id']));
         }
         if(!empty($filters['status']))
         {
            $this->db->where('n.status', $filters['status'] == 1 ? 1:0);
         }
      }

      $this->db->join('cms_menu_group g', 'g.menu_group_id=n.menu_group_id', 'LEFT');
      $this->db->join('cms_menu t', 't.menu_id=n.parent_id', 'LEFT');
      $this->db->join('cms_users u', 'u.user_id=n.created_by', 'LEFT');
      $result = $this->db->get($this->table_name.' n')->result();
      return $result;
   }

   /**
    *
    * View menu
    *
    * @return mixed
    */
   public function read($id, $filters = NULL)
   {
      $this->db->select('a.menu_id, a.title as name, p.title as menu_group, a.menu_group_id, a.updated_at, a.updated_by, u.firstname as admin, a.flag, a.detail, a.status, a.highlight, a.parent_id, a.label, a.action_listing, a.action_view, a.action_add, a.action_edit, a.action_delete, a.action_publish, a.action_highlight, a.group_name');
      $this->db->where('a.menu_id', (int)$id);
      $this->db->join('cms_menu_group p', 'a.menu_group_id=p.menu_group_id', 'LEFT');
      $this->db->join('cms_users u', 'u.user_id=p.created_by', 'LEFT');
      $result = $this->db->get($this->table_name.' a')->row();
      //echo $this->db->last_query();
      return $result;
   }
}