<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Xcaptcha
{
   private $CI = NULL;
   private $str_len = 5;

   function __construct()
   {
      $this->CI =& get_instance();
   }

   private function random_string($length)
   {
      $characters = "123456789ABCDEFGHJKLMNPQRSTUVWXYZ";
      $string = "";

      for($p = 0; $p < $length; $p++)
      {
         $string .= $characters[mt_rand(0, strlen($characters) - 1)];
      }

      return $string;
   }

   private function background_color()
   {
//      $characters = "ABCDEF0123456789";
//      $string = "#";
//
//      for($p = 0; $p < 6; $p++)
//      {
//         $string .= $characters[mt_rand(0, strlen($characters) - 1)];
//      }
//
//      if(config_item("capthcha_bgcolor"))
//      {
//         return config_item("capthcha_bgcolor");
//      }
//      else{
//         return $string;
//      }
      return '#ced4da'; // bootstrap input group color
   }

   private function hex2RGB($hexStr, $returnAsString = false, $seperator = ',')
   {
      $hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); // Gets a proper hex string
      $rgbArray = array();

      if(strlen($hexStr) == 6)
      { //If a proper hex code, convert using bitwise operation. No overhead... faster
         $colorVal = hexdec($hexStr);
         $rgbArray['red'] = 0xFF & ($colorVal >> 0x10);
         $rgbArray['green'] = 0xFF & ($colorVal >> 0x8);
         $rgbArray['blue'] = 0xFF & $colorVal;
      }
      else if(strlen($hexStr) == 3)
      {
         //if shorthand notation, need some string manipulations
         $rgbArray['red'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
         $rgbArray['green'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
         $rgbArray['blue'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
      }
      else {
         return false; //Invalid hex color code
      }

      return $returnAsString ? implode($seperator, $rgbArray) : $rgbArray; // returns the rgb string or the associative array
   }

   public function create($render = TRUE)
   {
      $random = $this->random_string($this->str_len);
      $this->CI->session->set_userdata('CAPTCHA_SESSION', $random);

      if($render)
      {
         header("Content-Type: image/png");
         $image      = @imagecreate(80, 38) or die("Cannot Initialize new GD image stream");
         $color 	   = $this->hex2RGB($this->background_color(), true);
         $color 	   = explode(',', $color);
         $bgcolor		= imagecolorallocate($image, $color[0], $color[1], $color[2]);
         $text_color = imagecolorallocate($image, 255,255,255);
         imagestring($image, 16, 16, 9,  $random, $text_color);
         imagepng($image);
         imagedestroy($image);
      }
   }

   public function custom($text)
   {
      header("Content-Type: image/png");
      $textLength = imagefontwidth(11) * strlen($text);
      $image      = @imagecreate($textLength, 20) or die("Cannot Initialize new GD image stream");
      $color      = $this->hex2RGB('#ffffff', true);
      $color      = explode(',', $color);
      $bgcolor    = imagecolorallocate($image, $color[0], $color[1], $color[2]);
      $text_color = imagecolorallocate($image, 0,0,0);
      imagestring($image, 11, 0, 0,  $text, $text_color);
      imagepng($image);
      imagedestroy($image);
   }

   public function valid()
   {
      return $this->CI->session->userdata('CAPTCHA_SESSION');
   }
}