<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Web_setting
{
   private $CI = NULL;

   function __construct()
   {
      $this->CI =& get_instance();
      $this->CI->load->model('shared/setting_model');
   }

   public function get_setting()
   {
      $listing = $this->CI->setting_model->listing();
      $data = new stdClass();
      if(!empty($listing))
      {
         foreach($listing as $row)
         {
            $field = $row->setting_var;
            //$data->$field = $row->setting_data;
            $data->setting_id = $row->setting_id;
            $setting_data = $row->setting_data;
            $data->$field = $setting_data;
         }
      }

      return $data;
   }

   public function create_config_file()
   {
      $listing = $this->CI->setting_model->listing();
      if(!empty($listing))
      {
         $config_file = fopen(WEBSITE_SETTING_CONFIG, "w") or die("Unable to open file!");
         $txt = "<?php\n";
         fwrite($config_file, $txt);
         foreach($listing as $row)
         {
            $txt = "define('SETTING_".strtoupper($row->setting_var)."', '".addslashes($row->setting_data)."');\n";
            fwrite($config_file, $txt);

            if($row->setting_var == 'admin_logo'){
               $logo_row = new stdClass();
               $logo_row->setting_id = 1;
               $logo_row->admin_logo = $row->setting_data;
               $txt = "define('SETTING_LOGO_URL', '".admin_logo_url($logo_row)."');\n";
               fwrite($config_file, $txt);
            }

            if($row->setting_var == 'seo_meta_image'){
               $meta_image_row = new stdClass();
               $meta_image_row->setting_id = 1;
               $meta_image_row->meta_image = $row->setting_data;
               $txt = "define('SETTING_SEO_META_IMAGE_URL', '".meta_image_url($meta_image_row)."');\n";
               fwrite($config_file, $txt);
            }

            if($row->setting_var == 'splash_image'){
               $splash_image_row = new stdClass();
               $splash_image_row->setting_id = 1;
               $splash_image_row->splash_image = $row->setting_data;
               $txt = "define('SETTING_SPLASH_IMAGE_URL', '".splash_image_url($splash_image_row)."');\n";
               fwrite($config_file, $txt);
            }

            if($row->setting_var == 'popup_image'){
               $popup_image_row = new stdClass();
               $popup_image_row->setting_id = 1;
               $popup_image_row->popup_image = $row->setting_data;
               $txt = "define('SETTING_POPUP_IMAGE_URL', '".popup_image_url($popup_image_row)."');\n";
               fwrite($config_file, $txt);
            }
         }

         fclose($config_file);
      }
   }

   public function update_session()
   {
      $user_session = $this->CI->session->userdata(LOGIN_SESSION_ADMIN);
      unset($user_session->settings);
      $user_session->settings = $this->get_setting();
      $this->CI->session->set_userdata(LOGIN_SESSION_ADMIN, $user_session);
   }
}