<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Contact extends Frontend_Rest
{
   public $base_model = 'front/product_model';
   public $menu_ctl = 'product';
   protected $primary_key = 'product_id';

   function __construct()
   {
      parent::__construct();
   }

   public function confirm()
   {
      $fullname = $this->input->post('fullname');
      $phone = $this->input->post('phone');
      $company = $this->input->post('company');
      $address = $this->input->post('address');

      if(!empty($fullname) && !empty($phone)) {
         $data = [];
         $data['page_menu'] = 'quotation';

         $data['fullname'] = input_to_sql($fullname);
         $data['phone'] = input_to_sql($phone);
         $data['company'] = input_to_sql($company);
         $data['address'] = input_to_sql($address);

         $message = $this->load->view('front/th/contact-email', $data, TRUE);
         //echo $message;
         $this->load->library('email_sender');
         $result = $this->email_sender->send([SETTING_RECIPIENT_CONTACT], 'ติดต่อเรา - Contact Form', $message);
         if($result) {
            $this->success($result);
         }
         else {
            $this->failedN('ไม่สามารถส่งอีเมลได้ในขณะนี้ กรุณาติดต่อผู้่ดูและเว็บไซต์');
         }
      }
   }
}