<?php defined('BASEPATH') OR exit('No direct script access allowed');

class User extends Restful_Controller
{
   public $base_model = 'bos/user_model';
   public $menu_ctl = 'user';

   function __construct()
   {
      parent::__construct();

      $this->cover_config = UPLOAD_ADMIN_AVATAR;
   }

   public function listing()
   {
      $filters = $this->input->get('filters');
      if($this->login_user_role_id != 1)
      {
         $filters['login_user_role_id'] = $this->login_user_role_id;
      }

      $listing = $this->model->listing($filters);
      if(!empty($listing))
      {
         foreach($listing as $row)
         {
            $row->cover_url = ASSETS.'img/admin-avatar-'.$row->gender.'.jpg';
            if(!empty($row->cover_ext))
            {
               $row->cover_url = $this->_avatar_url($row);
            }
         }
      }

      $res = new stdClass();
      $res->rows = $listing;
      $res->total_row = count($listing);
      $res->all_row = count($this->model->listing($filters));

      return $this->success($res);
   }

   public function read()
   {
      $id = input_to_sql($this->input->post('id'));
      if(!empty($id))
      {
         $row = $this->model->read($id, $this->filters_read);
         $row->cover_url = ASSETS.'img/admin-avatar-'.$row->gender.'.jpg';
         if(!empty($row->cover_ext))
         {
            $row->cover_url = $this->_avatar_url($row);
         }

         return $this->success($row);
      }
      else{
         return $this->failedN('Not found id.');
      }
   }

   private function _avatar_url($row)
   {
      return base_url(UPLOAD_ADMIN_AVATAR[0][0].$row->user_id.'.'.$row->cover_ext);
   }

   public function create()
   {
      $data = new stdClass();
      $data->created_by = $this->login_user_id;
      $data->role_id = $this->input->post('role_id');
      $last_id = $this->model->create_user($data);
      $this->update($last_id);
   }

   /**
    * Base : update row
    */
   public function update($user_id = NULL)
   {
      $data = new stdClass();
      if(isset($_POST) && !empty($_POST))
      {
         foreach($_POST as $key => $val)
         {
            $data->$key = input_to_sql($val);
         }
      }

      //From create
      if($user_id)
      {
         $data->user_id = $user_id;
      }

      $password = $data->password;
      $confirm_password = $data->confirm_password;
      if($password && $confirm_password)
      {
         if($password != $confirm_password)
         {
            $this->failedN('Password not match.');
            exit();
         }
         else {
            $this->load->library('bcrypt');
            $data->password = $this->bcrypt->hash_password($data->password);
         }
      }
      else{
         unset($data->password);
         unset($data->confirm_password);
      }

      if(!empty($_FILES['cover']['name']))
      {
         $data->cover_ext = file_ext($_FILES['cover']['name']);
      }

      $delete_cover = NULL;
      if(!empty($data->delete_cover)){
         $delete_cover = $data->delete_cover;
         $data->cover_ext = NULL;
         unset($data->delete_cover);
      }

      if(!empty($data))
      {
         $data->created_by = $this->login_user_id;
         $result = $this->model->update_user($data);
         if($result)
         {
            $this->_upload_cover($result); // $result = $id
            $this->_delete_cover_byid($result, $delete_cover);
            return $this->success($result);
         }
         else{
            return $this->failedN('Cannot update row.');
         }
      }
      else{
         return $this->failedN('Parameter not found.');
      }
   }

   public function listing_name()
   {
      $listing = $this->model->listing_name();

      $res = new stdClass();
      $res->rows = $listing;
      $res->total_row = count($listing);
      return $this->success($res);
   }
}