<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Setting extends Restful_Controller
{
   public $base_model = 'bos/setting_model';
   public $menu_ctl = 'setting';

   function __construct()
   {
      parent::__construct();

      $this->cover_config = UPLOAD_ADMIN_LOGO;
      $this->load->library('web_setting');
      $this->load->model('shared/upload_model');
   }

   public function listing()
   {
      $listing = $this->model->listing($this->filters_listing);
      if(!empty($listing))
      {
         $data = new stdClass();
         foreach($listing as $row)
         {
            $field = $row->setting_var;
            $data->$field = $row->setting_data;
            if($field == 'admin_logo' && !empty($row->setting_data))
            {
               $row_logo = new stdClass();
               $row_logo->setting_id = 1;
               $row_logo->admin_logo = $row->setting_data;
               $data->logo_url = admin_logo_url($row_logo);
            }
            if($field == 'seo_meta_image' && !empty($row->setting_data))
            {
               $row_meta_image = new stdClass();
               $row_meta_image->setting_id = 1;
               $row_meta_image->meta_image = $row->setting_data;
               $data->seo_meta_image_url = meta_image_url($row_meta_image);
            }
            if($field == 'splash_image' && !empty($row->setting_data))
            {
               $row_splash_image = new stdClass();
               $row_splash_image->setting_id = 1;
               $row_splash_image->splash_image = $row->setting_data;
               $data->splash_image_url = splash_image_url($row_splash_image);
            }
            if($field == 'popup_image' && !empty($row->setting_data))
            {
               $row_popup_image = new stdClass();
               $row_popup_image->setting_id = 1;
               $row_popup_image->popup_image = $row->setting_data;
               $data->popup_image_url = popup_image_url($row_popup_image);
            }
            if($field == 'custom_script_head' && !empty($row->setting_data))
            {
               $data->custom_script_head = output_str($row->setting_data);
            }
            if($field == 'custom_script_body' && !empty($row->setting_data))
            {
               $data->custom_script_body = output_str($row->setting_data);
            }
         }
      }

      return $this->success($data);
   }

   public function update()
   {
      $data = new stdClass();
      $data->admin_name = $this->input->post('admin_name');
      $data->admin_theme_primary = $this->input->post('admin_theme_primary');
      $data->admin_theme_secondary = $this->input->post('admin_theme_secondary');
      $data->admin_theme_textcolor = $this->input->post('admin_theme_textcolor');
      $data->admin_theme_gradient = $this->input->post('admin_theme_gradient');
      $data->admin_listing_perpage = $this->input->post('admin_listing_perpage');
      $data->admin_default_en = $this->input->post('admin_default_en');
      $data->admin_cache = $this->input->post('admin_cache');
      $data->custom_script_head = htmlentities($this->input->post('custom_script_head'));
      $data->custom_script_body = htmlentities($this->input->post('custom_script_body'));

      $data->website_limit_user_log = $this->input->post('website_limit_user_log');

      $data->seo_meta_title = $this->input->post('seo_meta_title');
      $data->seo_meta_keywords = $this->input->post('seo_meta_keywords');
      $data->seo_meta_description = $this->input->post('seo_meta_description');

      $data->social_tiktok = $this->input->post('social_tiktok');
      $data->social_line = $this->input->post('social_line');
      $data->social_youtube = $this->input->post('social_youtube');
      $data->social_instagram = $this->input->post('social_instagram');
      $data->social_facebook = $this->input->post('social_facebook');
      $data->social_twitter = $this->input->post('social_twitter');

      $data->contact_title = $this->input->post('contact_title');
      $data->contact_detail = $this->input->post('contact_detail');
      $data->contact_email = $this->input->post('contact_email');
      $data->contact_phone = $this->input->post('contact_phone');
      $data->contact_open = $this->input->post('contact_open');
      $data->contact_map = $this->input->post('contact_map');

      $data->splash_startdate = $this->input->post('splash_startdate');
      $data->splash_enddate = $this->input->post('splash_enddate');
      $data->splash_enable = $this->input->post('splash_enable');
      $data->splash_link = $this->input->post('splash_link');

      $data->popup_startdate = $this->input->post('popup_startdate');
      $data->popup_enddate = $this->input->post('popup_enddate');
      $data->popup_enable = $this->input->post('popup_enable');
      $data->popup_link = $this->input->post('popup_link');

      $data->news_tags_home = $this->input->post('news_tags_home');

      $data->smtp_hostname = $this->input->post('smtp_hostname');
      $data->smtp_username = $this->input->post('smtp_username');
      $data->smtp_password = $this->input->post('smtp_password');
      $data->smtp_port = $this->input->post('smtp_port');
      $data->smtp_secure = $this->input->post('smtp_secure');
      $data->smtp_sender_name = $this->input->post('smtp_sender_name');
      $data->smtp_sender_email = $this->input->post('smtp_sender_email');
      $data->smtp_reply_name = $this->input->post('smtp_reply_name');
      $data->smtp_reply_email = $this->input->post('smtp_reply_email');
      $data->smtp_enable = $this->input->post('smtp_enable');

      $data->recipient_order = $this->input->post('recipient_order');
      $data->recipient_contact = $this->input->post('recipient_contact');

      $data->text1_th = $this->input->post('text1_th');
      $data->text2_th = $this->input->post('text2_th');

      $data->text1_en = $this->input->post('text1_en');
      $data->text2_en = $this->input->post('text2_en');

      if(!empty($_FILES['cover']['name']))
      {
         $data->admin_logo = file_ext($_FILES['cover']['name']);
      }

      $delete_logo = NULL;
      if(!empty($this->input->post('delete_logo'))){
         $delete_logo = $this->input->post('delete_logo');
         $data->admin_logo = NULL;
      }

      if(!empty($data))
      {
         $data->created_by = $this->login_user_id;
         $id = $this->model->update($data);
         if($id)
         {
            $this->_upload_cover($id); // $result = $id
            $this->_delete_cover_byid($id, $delete_logo);
            $this->_upload_meta_image();
            $this->_upload_splash_image();
            $this->_upload_popup_image();

            $this->web_setting->update_session();
            $this->web_setting->create_config_file();

            clear_main_cache();

            return $id;
         }
         else{
            return FALSE;
         }
      }
      else{
         return $this->failedN('Parameter not found.');
      }
   }

   private function _upload_meta_image()
   {
      $data = new stdClass();

      if(!empty($_FILES['seo_meta_image']['name']))
      {
         $data->seo_meta_image = file_ext($_FILES['seo_meta_image']['name']);
      }

      $delete_meta_image = NULL;
      if(!empty($this->input->post('delete_meta_image'))){
         $delete_meta_image = $this->input->post('delete_meta_image');
         $data->seo_meta_image = NULL;
      }

      if(!empty($data))
      {
         $data->created_by = $this->login_user_id;
         $id = $this->model->update($data);
         if($id)
         {
            $this->cover_config = UPLOAD_META_IMAGE;
            $this->_upload_meta_cover($id); // $result = $id
            $this->_delete_cover_byid($id, $delete_meta_image);

            $this->web_setting->update_session();

            return $id;
         }
         else{
            return FALSE;
         }
      }
   }

   private function _upload_meta_cover($id)
   {
      if(!empty($_FILES['seo_meta_image']['name']))
      {
         $_FILES['cover']['name'] = $_FILES['seo_meta_image']['name'];
         $_FILES['cover']['tmp_name'] = $_FILES['seo_meta_image']['tmp_name'];
         $this->_remove_cover_file($id);
         $this->upload_model->upload_cover($id, $this->cover_config);
      }
   }

   private function _upload_splash_image()
   {
      $data = new stdClass();

      if(!empty($_FILES['splash_image']['name']))
      {
         $data->splash_image = file_ext($_FILES['splash_image']['name']);
      }

      $delete_splash_image = NULL;
      if(!empty($this->input->post('delete_splash_image'))){
         $delete_splash_image = $this->input->post('delete_splash_image');
         $data->splash_image = NULL;
      }

      if(!empty($data))
      {
         $data->created_by = $this->login_user_id;
         $id = $this->model->update($data);
         if($id)
         {
            $this->cover_config = UPLOAD_SPLASH;
            $this->_upload_splash_cover($id); // $result = $id
            $this->_delete_cover_byid($id, $delete_splash_image);

            $this->web_setting->update_session();

            return $id;
         }
         else{
            return FALSE;
         }
      }
   }

   private function _upload_splash_cover($id)
   {
      if(!empty($_FILES['splash_image']['name']))
      {
         $_FILES['cover']['name'] = $_FILES['splash_image']['name'];
         $_FILES['cover']['tmp_name'] = $_FILES['splash_image']['tmp_name'];
         $this->_remove_cover_file($id);
         $this->upload_model->upload_cover($id, $this->cover_config);
      }
   }

   private function _upload_popup_image()
   {
      $data = new stdClass();

      if(!empty($_FILES['popup_image']['name']))
      {
         $data->popup_image = file_ext($_FILES['popup_image']['name']);
      }

      $delete_popup_image = NULL;
      if(!empty($this->input->post('delete_popup_image'))){
         $delete_popup_image = $this->input->post('delete_popup_image');
         $data->popup_image = NULL;
      }

      if(!empty($data))
      {
         $data->created_by = $this->login_user_id;
         $id = $this->model->update($data);
         if($id)
         {
            $this->cover_config = UPLOAD_POPUP;
            $this->_upload_popup_cover($id); // $result = $id
            $this->_delete_cover_byid($id, $delete_popup_image);

            $this->web_setting->update_session();

            return $id;
         }
         else{
            return FALSE;
         }
      }
   }

   private function _upload_popup_cover($id)
   {
      if(!empty($_FILES['popup_image']['name']))
      {
         $_FILES['cover']['name'] = $_FILES['popup_image']['name'];
         $_FILES['cover']['tmp_name'] = $_FILES['popup_image']['tmp_name'];
         $this->_remove_cover_file($id);
         $this->upload_model->upload_cover($id, $this->cover_config);
      }
   }
}