<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Product extends Restful_Controller
{
   public $base_model = 'bos/product_model';
   public $menu_ctl = 'product';
   protected $primary_key = 'product_id';
   protected $allow_html_fields = ['detail', 'detail_en'];

   function __construct()
   {
      parent::__construct();
      $this->thumb_config = UPLOAD_PRODUCT_THUMB;
      $this->special_config = UPLOAD_PRODUCT_SPECIAL;

      $this->gallery_config = UPLOAD_PRODUCT_GALLERY;
      $this->gallery_model = 'bos/product_gallery_model';
      $this->gallery_parent_key = 'product_id';

      $this->pdf_config = UPLOAD_PRODUCT_SPEC;

      $this->load->model('shared/upload_model');
      $this->load->model('bos/product_item_model');
   }

   /**
    * Base : listing rows
    */
   public function listing()
   {
      if(!empty($this->input->get('filters')))
      {
         foreach($this->input->get('filters') as $key=>$val)
         {
            $this->filters_listing[$key] = input_to_sql($val);
         }
      }

      $listing = $this->model->listing($this->filters_listing);

      if(!empty($listing))
      {
         foreach($listing as $row)
         {
            $row->thumb_url = ASSETS_NOIMG_320;
            if(!empty($row->thumb_ext))
            {
               $row->thumb_url = product_thumb_url($row);
            }
            if(!empty($row->special_ext))
            {
               $row->special_url = product_special_url($row);
            }
         }
      }

      $res = new stdClass();
      $res->rows = $listing;
      $res->total_row = count($listing);
      $res->all_row = count($listing);

      return $this->success($res);
   }

   public function read($is_return = false)
   {
      $id = input_to_sql($this->input->post('id'));
      if(!empty($id))
      {
         $row = $this->model->read($id, $this->filters_read);

         $primary_key = $this->primary_key;
         if(!empty($row))
         {
            $row->thumb_url = ASSETS_NOIMG_320;
            $row->cover_url = ASSETS_NOIMG_320;
            if(!empty($row->thumb_ext))
            {
               $row->thumb_url = product_thumb_url($row);
            }
            if(!empty($row->special_ext))
            {
               $row->special_url = product_special_url($row);
            }
            if(!empty($row->pdf_ext))
            {
               $row->pdf_url = base_url(UPLOAD_PRODUCT_SPEC[0][0].$row->$primary_key.'.'.$row->pdf_ext.'?t='.time());
            }
         }

         $this->load->model('bos/product_gallery_model');
         $filter_gallery = [];
         $filter_gallery[$this->gallery_parent_key] = $row->product_id;
         $gallery_item = $this->product_gallery_model->listing_order($filter_gallery);
         $row->gallery_item = $gallery_item;
         if(!empty($gallery_item))
         {
            foreach($gallery_item as $item)
            {
               $item->gallery_url = product_gallery_url($item);
            }
         }

         $filter_item['product_id'] = $id;
         $row->items = $this->product_item_model->listing($filter_item);

         return $this->success($row);
      }
      else{
         return $this->failedN('Not found id.');
      }
   }

   /**
    * Base : delete rows
    */
   public function delete()
   {
      $ids = $this->input->post('ids');
      if(!empty($ids))
      {
         $this->model->delete($ids, $this->filters_delete);
         $this->_delete_cover();
         $this->_delete_pdf();
         $this->_delete_gallery();
         foreach($ids as $id) {
            $this->product_item_model->delete_parent('product_id', $id);
         }
      }
      else{
         return $this->failedN('Not found ids.');
      }
   }

   public function create()
   {
      $code = $this->input->post('code');
      $od = $this->input->post('od');
      $length = $this->input->post('length');
      $hole = $this->input->post('hole');
      $strength = $this->input->post('strength');
      $shear = $this->input->post('shear');
      $depth = $this->input->post('depth');
      $orderids = $this->input->post('orderids');

      unset($_POST['code']);
      unset($_POST['od']);
      unset($_POST['length']);
      unset($_POST['hole']);
      unset($_POST['strength']);
      unset($_POST['shear']);
      unset($_POST['depth']);
      unset($_POST['orderids']);

      $result = $this->create_record();
      if($result)
      {
         $this->update_item($result, $code, $od, $length, $hole, $strength, $shear, $depth, $orderids);
         return $this->success($result);
      }
      else{
         return $this->failedN('Cannot create row.');
      }
   }

   public function update()
   {
      $code = $this->input->post('code');
      $od = $this->input->post('od');
      $length = $this->input->post('length');
      $hole = $this->input->post('hole');
      $strength = $this->input->post('strength');
      $shear = $this->input->post('shear');
      $depth = $this->input->post('depth');
      $orderids = $this->input->post('orderids');

      unset($_POST['code']);
      unset($_POST['od']);
      unset($_POST['length']);
      unset($_POST['hole']);
      unset($_POST['strength']);
      unset($_POST['shear']);
      unset($_POST['depth']);
      unset($_POST['orderids']);

      $result = $this->update_record();
      if($result)
      {
         $this->update_item($result, $code, $od, $length, $hole, $strength, $shear, $depth, $orderids);
         return $this->success($result);
      }
      else{
         return $this->failedN('Cannot update row.');
      }
   }

   public function update_item($product_id, $code = NULL, $od = NULL, $length = NULL, $hole = NULL, $strength = NULL, $shear = NULL, $depth = NULL, $orderid = NULL)
   {
      $this->load->model('bos/product_item_model');
      $this->product_item_model->delete_parent('product_id', $product_id);

      if(!empty($code))
      {
         for($i=0;$i<count($code);$i++)
         {
            if(!empty($code[$i]))
            {
               $data = new stdClass();
               $data->orderid = input_to_sql($orderid[$i]);
               $data->code = input_to_sql($code[$i]);
               $data->od = input_to_sql($od[$i]);
               $data->length = input_to_sql($length[$i]);
               $data->hole = input_to_sql($hole[$i]);
               $data->strength = input_to_sql($strength[$i]);
               $data->shear = input_to_sql($shear[$i]);
               $data->depth = input_to_sql($depth[$i]);
               $data->created_by = $this->login_user_id;
               $data->product_id = $product_id;
               $data->highlight = 1;
               $data->status = 1;
               $this->product_item_model->create($data);
            }
         }
      }
   }

   public function duplicate()
   {
      $id = $this->input->post('id');
      if(!empty($id)) {
         $row = $this->model->read($id);

         //duplicate row
         $data = new stdClass();
         $data->product_category_id = $row->product_category_id;
         $data->title = $row->title;
         $data->title_en = $row->title_en;
         $data->intro = $row->intro;
         $data->intro_en = $row->intro_en;
         $data->detail = $row->detail;
         $data->detail_en = $row->detail_en;
         $data->keyword = $row->keyword;
         $data->keyword_en = $row->keyword_en;
         $data->youtube_url = $row->youtube_url;
         $data->status = $row->status;
         $data->highlight = $row->highlight;
         $data->orderid = 1;
         $data->created_by = $this->login_user_id;
         $data->thumb_ext = $row->thumb_ext;
         $data->pdf_ext = $row->pdf_ext;
         $data->special_ext = $row->special_ext;
         $new_id = $this->model->create($data);

         if(!empty($row->thumb_ext)) {
            $data->thumb_ext = $row->thumb_ext;
            copy(UPLOAD_PRODUCT_THUMB[0][0].($id.'.'.$data->thumb_ext), UPLOAD_PRODUCT_THUMB[0][0].($new_id.'.'.$data->thumb_ext));
         }

         if(!empty($row->special_ext)) {
            $data->special_ext = $row->special_ext;
            copy(UPLOAD_PRODUCT_SPECIAL[0][0].($id.'.'.$data->special_ext), UPLOAD_PRODUCT_SPECIAL[0][0].($new_id.'.'.$data->special_ext));
         }

         if(!empty($row->pdf_ext)) {
            $data->pdf_ext = $row->pdf_ext;
            copy(UPLOAD_PRODUCT_SPEC[0][0].($id.'.'.$data->pdf_ext), UPLOAD_PRODUCT_SPEC[0][0].($new_id.'.'.$data->pdf_ext));
         }

         $data = new stdClass();
         $data->rewrite_url = $row->rewrite_url . $id;
         $this->model->update($data);

         //duplicate gallery
         $this->load->model('bos/product_gallery_model');
         $filter_gallery = [];
         $filter_gallery[$this->gallery_parent_key] = $id;
         $gallery_item = $this->product_gallery_model->listing_order($filter_gallery);
         if(!empty($gallery_item))
         {
            foreach($gallery_item as $item)
            {
               $data = new stdClass();
               $data->product_id = $new_id;
               $data->cover_ext = $item->cover_ext;
               $data->cover_title = $item->cover_title;
               $data->cover_alt = $item->cover_alt;
               $data->status = $item->status;
               $data->highlight = $item->highlight;
               $data->orderid = $item->orderid;
               $data->created_by = $this->login_user_id; 
               $gid = $this->product_gallery_model->create($data);

               if(!empty($row->special_ext)) {
                  $data->special_ext = $row->special_ext;
                  copy(UPLOAD_PRODUCT_GALLERY[0][0].($item->gallery_id.'.'.$item->cover_ext), UPLOAD_PRODUCT_GALLERY[0][0].($gid.'.'.$item->cover_ext));
               }
            }
         }

         //duplicate product item

         $filter_item['product_id'] = $id;
         $items = $this->product_item_model->listing($filter_item);
         if(!empty($items)) {
            foreach ($items as $rs) {
               $data = new stdClass();
               $data->product_id = $new_id;
               $data->code = $rs->code;
               $data->od = $rs->od;
               $data->length = $rs->length;
               $data->hole = $rs->hole;
               $data->strength = $rs->strength;
               $data->shear = $rs->shear;
               $data->depth = $rs->depth;
               $data->status = $rs->status;
               $data->highlight = $rs->highlight;
               $data->orderid	 = $rs->orderid;
               $data->created_by = $this->login_user_id;
               $this->product_item_model->create($data);
            }
         }
      }

      return $this->successN('Duplicate successfully');
   }
}