<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends Base_Controller
{
   function __construct()
   {
      parent::__construct();

      $this->load->library('bcrypt');
      $this->load->library('verify_code');
      $this->load->helpers('jwt');
      $this->load->model('bos/login_model');
      $this->load->model('bos/user_model');
      $this->load->model('bos/user_permission_model');
      $this->load->model('bos/user_logs_model');
      $this->load->model('bos/menu_group_model');
      $this->load->model('bos/menu_model');
      $this->lang->load('auth', GLOBAL_USER_LANGUAGE);
   }

   public function auth()
   {
      //STEP 1 :: Prepare parameter
      $data = json_input();
      $msg = '';
      $login_status = $log_status = USER_LOGIN_FAILED;

      if(strlen($data->answer) != $this->verify_code->code_length() || $this->verify_code->current_code() != $data->answer)
      {
         return $this->failedN('Verify code does not match');
      }

      if(!empty($data) && !empty($data->email) && !empty($data->password) && !empty($data->answer))
      {
         //STEP 2 :: Find user account by email
         $user = $this->login_model->find($data->email);

         //STEP 3 :: Check existing
         if(!empty($user) && !empty($user->user_id))
         {
            //STEP :: 4 Check user status
            if(intval($user->status) === GLOBAL_STATUS_ENABLED)
            {
               //STEP 5 :: Check if user locked
               if(intval($user->locked) === 1){
                  $msg = 'USER_HASBEEN_LOCKED';
                  $user->login_attempts = 0;

                  if($this->_is_locked_expire($user->locked_at))
                  {
                     $this->user_model->unlock($user->user_id);
                     $user->locked = 0; //unlock user
                     $msg = '';
                  }
               }

               //STEP 6 :: If not lock user and compare password
               if(intval($user->locked) === 0)
               {
                  if($this->bcrypt->check_password($data->password, $user->password))
                  {
                     $msg = 'USER_LOGIN_SUCCESS';

                     //Get profile
                     $profile = $this->user_model->profile($user->user_id);

                     //Create menu for access
                     $menu_data = $this->_setup_menu($profile->role_id);

                     //Create token
                     $jwt_key = $this->config->item('jwt_encode_key');
                     $profile->login_date = date('Y-m-d H:i:s');
                     $token = JWT::encode($profile, $jwt_key);

                     //Store row
                     $res = new stdClass();
                     $res->user_id = $profile->user_id;
                     $res->firstname = $profile->firstname;
                     $res->cover_ext = $profile->cover_ext;
                     $res->gender = $profile->gender;
                     $res->email = $profile->email;
                     $res->role_id = $profile->role_id;
                     $res->role_name = $profile->role_name;
                     $res->menu = $menu_data['all_menu'];
                     $res->menu_group_names = $menu_data['menu_group_names'];
                     $res->menu_names = $menu_data['menu_names'];
                     $res->menu_ids = $menu_data['menu_ids'];
                     $res->token = $token;
                     $this->load->library('web_setting');
                     $res->settings = $this->web_setting->get_setting();
                     $res->created_at = datetime_now();

                     //Login successfully and finish
                     $login_status = $log_status = USER_LOGIN_SUCCESS;

                     $user->login_attempts = 0;

                     //Start session
                     $this->session->unset_userdata(LOGIN_SESSION_ADMIN);
                     $this->session->set_userdata(LOGIN_SESSION_ADMIN, $res);
                  }
                  else{

                     //Password not match
                     $msg = 'USER_LOGIN_PASSWORD_NOT_MATCH';
                  }

                  //STEP 7 :: Check if attempts exceeded
                  if($this->_exceeded($user->login_attempts))
                  {
                     $msg = 'USER_LOGIN_EXCEEDED';
                     $log_status = USER_LOGS_STATUS_LOCKED;
                     $user->login_attempts = 0;

                     $this->user_model->locked($data->email);
                  }
               }

            }
            else{

               //The user was disabled
               $msg = 'USER_WAS_DISABLED';
            }

            //STEP 8 :: Save login status
            $this->login_model->login_status($data, $login_status, $user->login_attempts+1);

         }
         else{

            //Not found user or failed
            $msg = 'USER_LOGIN_FAIL';
         }

         //STEP 9 :: Save logs
         $logs = new stdClass();
         $logs->component = $this->ct_ctrl;
         $logs->status = $log_status;
         $logs->action = USER_LOGS_ACTION_LOGIN;
         $logs->email = $data->email;
         $logs->user_id = !empty($profile->user_id) ? $profile->user_id:NULL;
         $this->user_logs_model->create_Log($logs);

         //create notification
         $this->cleanup();

         //Response to client
         if($login_status === USER_LOGIN_SUCCESS)
         {
            return $this->success($res, $this->lang->line($msg));
         }
         else{
            return $this->failedN($this->lang->line($msg));
         }

      }
      else{

         $msg = 'USER_LOGIN_EMPTY';

         //Response to client
         return $this->failedN($this->lang->line($msg));
      }

   }

   /**
    *
    * Check user login attempts
    *
    * @return bool
    */
   private function _exceeded($attempts)
   {
      //Check if exceed fail
      if(LOGIN_FAILED_LIMIT_LOCKED > 0 && $attempts >= LOGIN_FAILED_LIMIT_LOCKED)
      {
         return TRUE;
      }
      return FALSE;
   }

   /**
    *
    * Check expire user lock
    *
    * @param $lastlogin_at
    * @return bool
    */
   private function _is_locked_expire($locked_at)
   {
      $diff_minute = 0;
      try{
         $d1 = new DateTime($locked_at);
         $d2 = new DateTime();
         $diff_minute = ($d2->getTimestamp() - $d1->getTimestamp()) / 60;
         //$diff_minute = 10;
      }
      catch (Exception $err){

      }

      return ($diff_minute > LOGIN_FAILED_LIMIT_TIME);
   }


   private function _setup_menu($role_id)
   {
      $result = NULL;
      $all_menu_groups = [];
      $all_menu_group_ids = [];
      $all_menus = [];

      $permits = NULL;
      $permit_menu_groups = [];

      //Get row
      $permission_row = $this->user_permission_model->list_by_role($role_id);
      $menu_group_row = $this->menu_group_model->listing();
      $menu_row = $this->menu_model->listing();

      //Prepare permission
      if(!empty($permission_row))
      {
         foreach($permission_row as $row)
         {
            $permit_menu_groups[] = $row->menu_group_id;
            $permits[$row->menu_id] = [
               'listing' => $row->action_listing == 1 ? 1:0, //Can be view
               'view' => $row->action_view == 1 ? 1:0, //Can be listing
               'add' => $row->action_add == 1 ? 1:0, //Can be add
               'edit' => $row->action_edit == 1 ? 1:0, //Can be edit
               'delete' => $row->action_delete == 1 ? 1:0, //Can be delete
               'publish' => $row->action_publish == 1 ? 1:0, //Can be publish
               'highlight' => $row->action_highlight == 1 ? 1:0, //Can be highlight
            ];
         }
      }

      //Setup menu from permission
      $menu_group_names = [];
      $menu_names = [];
      $menu_ids = [];
      if(!empty($permits))
      {
         //Prepare menu
         if(!empty($menu_row))
         {
            foreach($menu_row as $row)
            {
               if(isset($permits[$row->menu_id]))
               {
                  $all_menus[$row->menu_group_id][] = [
                     'id' => $row->menu_id,
                     'group_id' => $row->menu_group_id,
                     'parent_id' => $row->parent_id,
                     'title' => $row->title,
                     'label' => $row->label,
                     'flag' => $row->flag,
                     'group_name' => $row->group_name,
                     'permits' => $permits[$row->menu_id]
                  ];
                  $menu_names[$row->flag] = $row->label;
                  $menu_ids[$row->flag] = $row->menu_id;
               }
            }
         }

         //Prepare menu group
         if(!empty($menu_group_row))
         {
            foreach($menu_group_row as $row)
            {
               $all_menu_group_ids[] = $row->menu_group_id;
               $all_menu_groups[$row->menu_group_id] = [
                  'group_id' => $row->menu_group_id,
                  'title' => $row->title,
                  'icon' => $row->icon,
                  'flag' => $row->flag
               ];
               $menu_group_names[$row->flag] = $row->title;
            }
         }

         //Intersection menu group
         if(!empty($all_menu_group_ids) && !empty($permit_menu_groups))
         {
            $new_menu_group = array_intersect($all_menu_group_ids, $permit_menu_groups);
            foreach ($new_menu_group as $menu_group_id)
            {
               //Menu group
               $result[] = [
                  'group' => [
                     'group_id' => $all_menu_groups[$menu_group_id]['group_id'],
                     'title' => $all_menu_groups[$menu_group_id]['title'],
                     'icon' => $all_menu_groups[$menu_group_id]['icon'],
                     'flag' => $all_menu_groups[$menu_group_id]['flag'],
                     'items' => $all_menus[$menu_group_id]
                  ]
               ];
            }
         }
      }

      //TODO :: check menu permission from request again !!

      return [
         'all_menu' => $result,
         'menu_group_names' => $menu_group_names,
         'menu_names' => $menu_names,
         'menu_ids' => $menu_ids
      ];
   }

   public function logout()
   {
      //Check current user session
      $user_session = $this->session->userdata(LOGIN_SESSION_ADMIN);
      if($user_session) {

         //Save logs
         $logs = new stdClass();
         $logs->component = $this->ct_ctrl;
         $logs->status = USER_LOGS_STATUS_SUCCESS;
         $logs->action = USER_LOGS_ACTION_LOGOUT;
         $this->user_logs_model->create_Log($logs);

         $this->session->unset_userdata(LOGIN_SESSION_ADMIN);

         //Response to client
         return $this->successN();

      }else {

         //Not found session
         return $this->unauthorized_msg('1');
      }
   }

   protected function unauthorized_msg($id)
   {
      return $this->failedN('Un authorized request. ('.$id.')', self::HTTP_UNAUTHORIZED);
   }

   private function cleanup()
   {
      if(!empty(SETTING_WEBSITE_LIMIT_USER_LOG))
      {
         $this->load->model('shared/user_logs_model');
         $listing = $this->user_logs_model->listing();
         if(!empty($listing) && count($listing) > SETTING_WEBSITE_LIMIT_USER_LOG)
         {
            $latest_row = $listing[SETTING_WEBSITE_LIMIT_USER_LOG-1];
            $ids = $latest_row->log_id;
            $filters['delete_more_id'] = $ids;
            $this->user_logs_model->delete([$ids], $filters);
         }
      }
   }
}