<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Search extends Frontend_View
{
   function __construct()
   {
      parent::__construct();
   }

   public function index()
   {
      $data = [];
      $data['page_menu'] = 'search';

      $q = input_to_sql($this->input->get('q'));
      if(!empty($q)) {
         $this->load->model('front/product_model');
         $filters['q'] = $q;
         $data['product_listing'] = $this->product_model->listing($filters);
         $data['q'] = $q;
      }

      $this->view('search', $data);
   }

   public function spec()
   {
      $data = [];
      $data['page_menu'] = 'search-by-spec';

      $select_product_category_id = input_to_sql($this->input->get('select_product_category_id'));
      $select_product_id = input_to_sql($this->input->get('select_product_id'));
      $select_product_od = input_to_sql($this->input->get('select_product_od'));
      $select_product_len = input_to_sql($this->input->get('select_product_len'));

      if(!empty($select_product_category_id)) {
         $this->load->model('front/product_model');
         $this->load->model('front/product_item_model');
         $filters['product_category_id'] = $select_product_category_id;
         $filters['product_id'] = $select_product_id;
         $filters['product_od'] = $select_product_od;
         $filters['product_length'] = $select_product_len;
         $product_listing = $this->product_model->listing($filters);

         if(!empty($product_listing)) {
            foreach ($product_listing as $rs) {
               $filter_item['product_id'] = $rs->product_id;
               $filter_item['od'] = $select_product_od;
               $filter_item['length'] = $select_product_len;
               $rs->items = $this->product_item_model->listing_order($filter_item);
            }
         }
         $data['product_listing'] = $product_listing;
      }

      $this->view('search-by-spec', $data);
   }
}