// ## globalNav.js
// 	Contains the dynamic functionality for the drop down navigation found at the top of most templates.

// FUNCTION LIST:
// 	init();
// 	menuOn();
// 	menuOff();
//	menuLinkOn();
// 	menuLinkOff();
// 	linkSwap();
// 	arrowSwap();

// TEMPLATE(S) USED:
// 	brochure_request.html
// 	coming_veh.html
// 	contact.html
// 	corporate.html
// 	dealer_results.html
// 	gallery.html
// 	line_up.html
// 	main.html
// 	performance.html
// 	specs.html
// 	vehicles_home.html

var menuTimeout;
var currentMenu;
//var imgPathNav = "images/menu/";	// Image path location for Global Nav menu images.
var imgPathNav = "http://www.nissan-th.com/images/menu/"
//var imgPath = "images/";			// Image path location for all other images.
var imgPath = "http://www.nissan-th.com/images/"
var navIsLoaded = false;

// Initializing the global navigation

// change init() to globalNavInit()
function init() {
	DynLayerInit()
	navIsLoaded = true;	// boolean to true when initialization is complete
}

// Display the dropdown menu.
// inputs: menuName  - name of the menu DIV layer without the Div.  ie. vehicles
// output: none
function menuOn(menuName) {
	var theMenu
	if (!navIsLoaded) return;	// check if initialization is complete
	if (menuTimeout) clearTimeout(menuTimeout);	// clear the timeout
	
	if (currentMenu) {			// hide the current menu
		theMenu = eval(currentMenu);
		theMenu.hide();
	}
	currentMenu = menuName;	
	theMenu = eval(currentMenu);
	theMenu.show();				// display menuName
	menuTimeout = setTimeout(currentMenu + '.hide()', 3000);		// set the timeout 
}

// Hides the dropdown menus
// inputs: menuName - name of the menu DIV layer without the Div.  ie. vehicles
// outputs: none
function menuOff(menuName) {
	
	if (!navIsLoaded) return	// check if initialization is complete
	
	if (menuTimeout) clearTimeout(menuTimeout)	// clear the current timeout
	menuTimeout = setTimeout(menuName + '.hide()', 330)		// set the new timeout
}

// Swaps the menu image to the ON state.
// input: imgName - name of the image to turn on
// output: swaps the image to the ON state
function menuLinkOn(imgName) {
	var theImage;
	
	if (menuTimeout) clearTimeout(menuTimeout);
	theImage = (is.ns4) ? eval("document.layers['" + currentMenu + "Div'].document.images['" + imgName + "']") : eval("document." + imgName);
	theImage.src = imgPathNav + "tnav_lnk_" + imgName + "_on.gif";
}

// Swaps the menu image to the OFF state.
function menuLinkOff(imgName) {
	var theImage;
	theImage = (is.ns4) ? eval("document.layers['" + currentMenu + "Div'].document.images['" + imgName + "']") : eval("document." + imgName);
	theImage.src = imgPathNav + "tnav_lnk_" + imgName + ".gif";
	menuOff(currentMenu);
}

// Swaps the link image.
// input: 	imgName - name of the image
//			ON - on or off state
function linkSwap(imgName, ON) {
	var theImage = eval("document." + imgName);
	theImage.src = imgPath + imgName + ((ON) ? "_on":"") + ".gif"
}

// Swaps the arrow image.
// input: 	imgName - name of the image
//			ON - on or off state
function arrowSwap(linkName, ON, obj, obj2) {
	var theImage = 'document.'
	
	if (obj && is.ie) {
		theImage += 'all.'
	} else if (obj && is.ns) {
	 	theImage += obj + '.document.'
	} 
	
	if (obj2 && is.ns) {
		theImage += obj2 + '.document.'
	}

	theImage += linkName;

	theImageObj = eval(theImage);

	theImageObj.src = imgPath + "g_arrow" + ((ON) ? "_on":"") + ".gif";
}


// Swaps the arrow image.
// input: 	imgName - name of the image
//			ON - on or off state
function arrowSwapUp(linkName, ON, obj, obj2) {
	var theImage = 'document.'
	
	if (obj && is.ie) {
		theImage += 'all.'
	} else if (obj && is.ns) {
	 	theImage += obj + '.document.'
	} 
	
	if (obj2 && is.ns) {
		theImage += obj2 + '.document.'
	}

	theImage += linkName
	theImageObj = eval(theImage);

	theImageObj.src = imgPath + "page_up" + ((ON) ? "_on":"") + ".gif";
}